/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values to use to filter results from the <a
 * href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEvents.html">DescribeEvents</a> and <a
 * href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventAggregates.html"
 * >DescribeEventAggregates</a> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventFilter implements SdkPojo, Serializable, ToCopyableBuilder<EventFilter.Builder, EventFilter> {
    private static final SdkField<List<String>> EVENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventArns")
            .getter(getter(EventFilter::eventArns))
            .setter(setter(Builder::eventArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_TYPE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventTypeCodes")
            .getter(getter(EventFilter::eventTypeCodes))
            .setter(setter(Builder::eventTypeCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("services")
            .getter(getter(EventFilter::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(EventFilter::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("availabilityZones")
            .getter(getter(EventFilter::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateTimeRange>> START_TIMES_FIELD = SdkField
            .<List<DateTimeRange>> builder(MarshallingType.LIST)
            .memberName("startTimes")
            .getter(getter(EventFilter::startTimes))
            .setter(setter(Builder::startTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateTimeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateTimeRange>> END_TIMES_FIELD = SdkField
            .<List<DateTimeRange>> builder(MarshallingType.LIST)
            .memberName("endTimes")
            .getter(getter(EventFilter::endTimes))
            .setter(setter(Builder::endTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateTimeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateTimeRange>> LAST_UPDATED_TIMES_FIELD = SdkField
            .<List<DateTimeRange>> builder(MarshallingType.LIST)
            .memberName("lastUpdatedTimes")
            .getter(getter(EventFilter::lastUpdatedTimes))
            .setter(setter(Builder::lastUpdatedTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateTimeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENTITY_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entityArns")
            .getter(getter(EventFilter::entityArns))
            .setter(setter(Builder::entityArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENTITY_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entityValues")
            .getter(getter(EventFilter::entityValues))
            .setter(setter(Builder::entityValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_TYPE_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventTypeCategories")
            .getter(getter(EventFilter::eventTypeCategoriesAsStrings))
            .setter(setter(Builder::eventTypeCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, String>>> TAGS_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(EventFilter::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_STATUS_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventStatusCodes")
            .getter(getter(EventFilter::eventStatusCodesAsStrings))
            .setter(setter(Builder::eventStatusCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatusCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARNS_FIELD,
            EVENT_TYPE_CODES_FIELD, SERVICES_FIELD, REGIONS_FIELD, AVAILABILITY_ZONES_FIELD, START_TIMES_FIELD, END_TIMES_FIELD,
            LAST_UPDATED_TIMES_FIELD, ENTITY_ARNS_FIELD, ENTITY_VALUES_FIELD, EVENT_TYPE_CATEGORIES_FIELD, TAGS_FIELD,
            EVENT_STATUS_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eventArns;

    private final List<String> eventTypeCodes;

    private final List<String> services;

    private final List<String> regions;

    private final List<String> availabilityZones;

    private final List<DateTimeRange> startTimes;

    private final List<DateTimeRange> endTimes;

    private final List<DateTimeRange> lastUpdatedTimes;

    private final List<String> entityArns;

    private final List<String> entityValues;

    private final List<String> eventTypeCategories;

    private final List<Map<String, String>> tags;

    private final List<String> eventStatusCodes;

    private EventFilter(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.regions = builder.regions;
        this.availabilityZones = builder.availabilityZones;
        this.startTimes = builder.startTimes;
        this.endTimes = builder.endTimes;
        this.lastUpdatedTimes = builder.lastUpdatedTimes;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.eventTypeCategories = builder.eventTypeCategories;
        this.tags = builder.tags;
        this.eventStatusCodes = builder.eventStatusCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventArns() {
        return eventArns != null && !(eventArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event ARNs (unique identifiers). For example:
     * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventArns} method.
     * </p>
     * 
     * @return A list of event ARNs (unique identifiers). For example:
     *         <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
     */
    public final List<String> eventArns() {
        return eventArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypeCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTypeCodes() {
        return eventTypeCodes != null && !(eventTypeCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unique identifiers for event types. For example,
     * <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeCodes} method.
     * </p>
     * 
     * @return A list of unique identifiers for event types. For example,
     *         <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
     */
    public final List<String> eventTypeCodes() {
        return eventTypeCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return The Amazon Web Services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
     */
    public final List<String> services() {
        return services;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return A list of Amazon Web Services Regions.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return A list of Amazon Web Services Availability Zones.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the StartTimes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStartTimes() {
        return startTimes != null && !(startTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dates and times that the event began.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStartTimes} method.
     * </p>
     * 
     * @return A list of dates and times that the event began.
     */
    public final List<DateTimeRange> startTimes() {
        return startTimes;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndTimes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndTimes() {
        return endTimes != null && !(endTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dates and times that the event ended.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndTimes} method.
     * </p>
     * 
     * @return A list of dates and times that the event ended.
     */
    public final List<DateTimeRange> endTimes() {
        return endTimes;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastUpdatedTimes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastUpdatedTimes() {
        return lastUpdatedTimes != null && !(lastUpdatedTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dates and times that the event was last updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastUpdatedTimes} method.
     * </p>
     * 
     * @return A list of dates and times that the event was last updated.
     */
    public final List<DateTimeRange> lastUpdatedTimes() {
        return lastUpdatedTimes;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntityArns() {
        return entityArns != null && !(entityArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity ARNs (unique identifiers).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityArns} method.
     * </p>
     * 
     * @return A list of entity ARNs (unique identifiers).
     */
    public final List<String> entityArns() {
        return entityArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityValues() {
        return entityValues != null && !(entityValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
     * <code>vol-426ab23e</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityValues} method.
     * </p>
     * 
     * @return A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
     *         <code>vol-426ab23e</code>).
     */
    public final List<String> entityValues() {
        return entityValues;
    }

    /**
     * <p>
     * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>, or
     * <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeCategories} method.
     * </p>
     * 
     * @return A list of event type category codes. Possible values are <code>issue</code>,
     *         <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
     *         <code>investigation</code> value isn't supported at this time.
     */
    public final List<EventTypeCategory> eventTypeCategories() {
        return _eventTypeCategoryListCopier.copyStringToEnum(eventTypeCategories);
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypeCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTypeCategories() {
        return eventTypeCategories != null && !(eventTypeCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>, or
     * <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeCategories} method.
     * </p>
     * 
     * @return A list of event type category codes. Possible values are <code>issue</code>,
     *         <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
     *         <code>investigation</code> value isn't supported at this time.
     */
    public final List<String> eventTypeCategoriesAsStrings() {
        return eventTypeCategories;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of entity tags attached to the affected entity.
     * </p>
     * <note>
     * <p>
     * Currently, the <code>tags</code> property isn't supported.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of entity tags attached to the affected entity.</p> <note>
     *         <p>
     *         Currently, the <code>tags</code> property isn't supported.
     *         </p>
     */
    public final List<Map<String, String>> tags() {
        return tags;
    }

    /**
     * <p>
     * A list of event status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventStatusCodes} method.
     * </p>
     * 
     * @return A list of event status codes.
     */
    public final List<EventStatusCode> eventStatusCodes() {
        return _eventStatusCodeListCopier.copyStringToEnum(eventStatusCodes);
    }

    /**
     * For responses, this returns true if the service returned a value for the EventStatusCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventStatusCodes() {
        return eventStatusCodes != null && !(eventStatusCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventStatusCodes} method.
     * </p>
     * 
     * @return A list of event status codes.
     */
    public final List<String> eventStatusCodesAsStrings() {
        return eventStatusCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEventArns() ? eventArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypeCodes() ? eventTypeCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStartTimes() ? startTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEndTimes() ? endTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLastUpdatedTimes() ? lastUpdatedTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityArns() ? entityArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityValues() ? entityValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypeCategories() ? eventTypeCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEventStatusCodes() ? eventStatusCodesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter) obj;
        return hasEventArns() == other.hasEventArns() && Objects.equals(eventArns(), other.eventArns())
                && hasEventTypeCodes() == other.hasEventTypeCodes() && Objects.equals(eventTypeCodes(), other.eventTypeCodes())
                && hasServices() == other.hasServices() && Objects.equals(services(), other.services())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones()) && hasStartTimes() == other.hasStartTimes()
                && Objects.equals(startTimes(), other.startTimes()) && hasEndTimes() == other.hasEndTimes()
                && Objects.equals(endTimes(), other.endTimes()) && hasLastUpdatedTimes() == other.hasLastUpdatedTimes()
                && Objects.equals(lastUpdatedTimes(), other.lastUpdatedTimes()) && hasEntityArns() == other.hasEntityArns()
                && Objects.equals(entityArns(), other.entityArns()) && hasEntityValues() == other.hasEntityValues()
                && Objects.equals(entityValues(), other.entityValues())
                && hasEventTypeCategories() == other.hasEventTypeCategories()
                && Objects.equals(eventTypeCategoriesAsStrings(), other.eventTypeCategoriesAsStrings())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasEventStatusCodes() == other.hasEventStatusCodes()
                && Objects.equals(eventStatusCodesAsStrings(), other.eventStatusCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventFilter").add("EventArns", hasEventArns() ? eventArns() : null)
                .add("EventTypeCodes", hasEventTypeCodes() ? eventTypeCodes() : null)
                .add("Services", hasServices() ? services() : null).add("Regions", hasRegions() ? regions() : null)
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("StartTimes", hasStartTimes() ? startTimes() : null).add("EndTimes", hasEndTimes() ? endTimes() : null)
                .add("LastUpdatedTimes", hasLastUpdatedTimes() ? lastUpdatedTimes() : null)
                .add("EntityArns", hasEntityArns() ? entityArns() : null)
                .add("EntityValues", hasEntityValues() ? entityValues() : null)
                .add("EventTypeCategories", hasEventTypeCategories() ? eventTypeCategoriesAsStrings() : null)
                .add("Tags", hasTags() ? tags() : null)
                .add("EventStatusCodes", hasEventStatusCodes() ? eventStatusCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventArns":
            return Optional.ofNullable(clazz.cast(eventArns()));
        case "eventTypeCodes":
            return Optional.ofNullable(clazz.cast(eventTypeCodes()));
        case "services":
            return Optional.ofNullable(clazz.cast(services()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "availabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "startTimes":
            return Optional.ofNullable(clazz.cast(startTimes()));
        case "endTimes":
            return Optional.ofNullable(clazz.cast(endTimes()));
        case "lastUpdatedTimes":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimes()));
        case "entityArns":
            return Optional.ofNullable(clazz.cast(entityArns()));
        case "entityValues":
            return Optional.ofNullable(clazz.cast(entityValues()));
        case "eventTypeCategories":
            return Optional.ofNullable(clazz.cast(eventTypeCategoriesAsStrings()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "eventStatusCodes":
            return Optional.ofNullable(clazz.cast(eventStatusCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventFilter, T> g) {
        return obj -> g.apply((EventFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventFilter> {
        /**
         * <p>
         * A list of event ARNs (unique identifiers). For example:
         * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * </p>
         * 
         * @param eventArns
         *        A list of event ARNs (unique identifiers). For example:
         *        <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventArns(Collection<String> eventArns);

        /**
         * <p>
         * A list of event ARNs (unique identifiers). For example:
         * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * </p>
         * 
         * @param eventArns
         *        A list of event ARNs (unique identifiers). For example:
         *        <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventArns(String... eventArns);

        /**
         * <p>
         * A list of unique identifiers for event types. For example,
         * <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * </p>
         * 
         * @param eventTypeCodes
         *        A list of unique identifiers for event types. For example,
         *        <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCodes(Collection<String> eventTypeCodes);

        /**
         * <p>
         * A list of unique identifiers for event types. For example,
         * <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * </p>
         * 
         * @param eventTypeCodes
         *        A list of unique identifiers for event types. For example,
         *        <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCodes(String... eventTypeCodes);

        /**
         * <p>
         * The Amazon Web Services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * </p>
         * 
         * @param services
         *        The Amazon Web Services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<String> services);

        /**
         * <p>
         * The Amazon Web Services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * </p>
         * 
         * @param services
         *        The Amazon Web Services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(String... services);

        /**
         * <p>
         * A list of Amazon Web Services Regions.
         * </p>
         * 
         * @param regions
         *        A list of Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * A list of Amazon Web Services Regions.
         * </p>
         * 
         * @param regions
         *        A list of Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * A list of Amazon Web Services Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Amazon Web Services Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Amazon Web Services Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Amazon Web Services Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * A list of dates and times that the event began.
         * </p>
         * 
         * @param startTimes
         *        A list of dates and times that the event began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimes(Collection<DateTimeRange> startTimes);

        /**
         * <p>
         * A list of dates and times that the event began.
         * </p>
         * 
         * @param startTimes
         *        A list of dates and times that the event began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimes(DateTimeRange... startTimes);

        /**
         * <p>
         * A list of dates and times that the event began.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.DateTimeRange.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.health.model.DateTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.DateTimeRange.Builder#build()} is called immediately and
         * its result is passed to {@link #startTimes(List<DateTimeRange>)}.
         * 
         * @param startTimes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.DateTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimes(java.util.Collection<DateTimeRange>)
         */
        Builder startTimes(Consumer<DateTimeRange.Builder>... startTimes);

        /**
         * <p>
         * A list of dates and times that the event ended.
         * </p>
         * 
         * @param endTimes
         *        A list of dates and times that the event ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimes(Collection<DateTimeRange> endTimes);

        /**
         * <p>
         * A list of dates and times that the event ended.
         * </p>
         * 
         * @param endTimes
         *        A list of dates and times that the event ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimes(DateTimeRange... endTimes);

        /**
         * <p>
         * A list of dates and times that the event ended.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.DateTimeRange.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.health.model.DateTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.DateTimeRange.Builder#build()} is called immediately and
         * its result is passed to {@link #endTimes(List<DateTimeRange>)}.
         * 
         * @param endTimes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.DateTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endTimes(java.util.Collection<DateTimeRange>)
         */
        Builder endTimes(Consumer<DateTimeRange.Builder>... endTimes);

        /**
         * <p>
         * A list of dates and times that the event was last updated.
         * </p>
         * 
         * @param lastUpdatedTimes
         *        A list of dates and times that the event was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes);

        /**
         * <p>
         * A list of dates and times that the event was last updated.
         * </p>
         * 
         * @param lastUpdatedTimes
         *        A list of dates and times that the event was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimes(DateTimeRange... lastUpdatedTimes);

        /**
         * <p>
         * A list of dates and times that the event was last updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.DateTimeRange.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.health.model.DateTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.DateTimeRange.Builder#build()} is called immediately and
         * its result is passed to {@link #lastUpdatedTimes(List<DateTimeRange>)}.
         * 
         * @param lastUpdatedTimes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.DateTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdatedTimes(java.util.Collection<DateTimeRange>)
         */
        Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder>... lastUpdatedTimes);

        /**
         * <p>
         * A list of entity ARNs (unique identifiers).
         * </p>
         * 
         * @param entityArns
         *        A list of entity ARNs (unique identifiers).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArns(Collection<String> entityArns);

        /**
         * <p>
         * A list of entity ARNs (unique identifiers).
         * </p>
         * 
         * @param entityArns
         *        A list of entity ARNs (unique identifiers).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArns(String... entityArns);

        /**
         * <p>
         * A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
         * <code>vol-426ab23e</code>).
         * </p>
         * 
         * @param entityValues
         *        A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
         *        <code>vol-426ab23e</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityValues(Collection<String> entityValues);

        /**
         * <p>
         * A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
         * <code>vol-426ab23e</code>).
         * </p>
         * 
         * @param entityValues
         *        A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
         *        <code>vol-426ab23e</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityValues(String... entityValues);

        /**
         * <p>
         * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>
         * , or <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this
         * time.
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes. Possible values are <code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
         *        <code>investigation</code> value isn't supported at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>
         * , or <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this
         * time.
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes. Possible values are <code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
         *        <code>investigation</code> value isn't supported at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategoriesWithStrings(String... eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>
         * , or <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this
         * time.
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes. Possible values are <code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
         *        <code>investigation</code> value isn't supported at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>
         * , or <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this
         * time.
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes. Possible values are <code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
         *        <code>investigation</code> value isn't supported at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategories(EventTypeCategory... eventTypeCategories);

        /**
         * <p>
         * A map of entity tags attached to the affected entity.
         * </p>
         * <note>
         * <p>
         * Currently, the <code>tags</code> property isn't supported.
         * </p>
         * </note>
         * 
         * @param tags
         *        A map of entity tags attached to the affected entity.</p> <note>
         *        <p>
         *        Currently, the <code>tags</code> property isn't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<? extends Map<String, String>> tags);

        /**
         * <p>
         * A map of entity tags attached to the affected entity.
         * </p>
         * <note>
         * <p>
         * Currently, the <code>tags</code> property isn't supported.
         * </p>
         * </note>
         * 
         * @param tags
         *        A map of entity tags attached to the affected entity.</p> <note>
         *        <p>
         *        Currently, the <code>tags</code> property isn't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String>... tags);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodesWithStrings(Collection<String> eventStatusCodes);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodesWithStrings(String... eventStatusCodes);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodes(Collection<EventStatusCode> eventStatusCodes);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodes(EventStatusCode... eventStatusCodes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eventArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventTypeCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> services = DefaultSdkAutoConstructList.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<DateTimeRange> startTimes = DefaultSdkAutoConstructList.getInstance();

        private List<DateTimeRange> endTimes = DefaultSdkAutoConstructList.getInstance();

        private List<DateTimeRange> lastUpdatedTimes = DefaultSdkAutoConstructList.getInstance();

        private List<String> entityArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> entityValues = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventTypeCategories = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, String>> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventStatusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventFilter model) {
            eventArns(model.eventArns);
            eventTypeCodes(model.eventTypeCodes);
            services(model.services);
            regions(model.regions);
            availabilityZones(model.availabilityZones);
            startTimes(model.startTimes);
            endTimes(model.endTimes);
            lastUpdatedTimes(model.lastUpdatedTimes);
            entityArns(model.entityArns);
            entityValues(model.entityValues);
            eventTypeCategoriesWithStrings(model.eventTypeCategories);
            tags(model.tags);
            eventStatusCodesWithStrings(model.eventStatusCodes);
        }

        public final Collection<String> getEventArns() {
            if (eventArns instanceof SdkAutoConstructList) {
                return null;
            }
            return eventArns;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String... eventArns) {
            eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final Collection<String> getEventTypeCodes() {
            if (eventTypeCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return eventTypeCodes;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String... eventTypeCodes) {
            eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final Collection<String> getServices() {
            if (services instanceof SdkAutoConstructList) {
                return null;
            }
            return services;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String... services) {
            services(Arrays.asList(services));
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final List<DateTimeRange.Builder> getStartTimes() {
            List<DateTimeRange.Builder> result = _dateTimeRangeListCopier.copyToBuilder(this.startTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStartTimes(Collection<DateTimeRange.BuilderImpl> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copyFromBuilder(startTimes);
        }

        @Override
        public final Builder startTimes(Collection<DateTimeRange> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copy(startTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startTimes(DateTimeRange... startTimes) {
            startTimes(Arrays.asList(startTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startTimes(Consumer<DateTimeRange.Builder>... startTimes) {
            startTimes(Stream.of(startTimes).map(c -> DateTimeRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DateTimeRange.Builder> getEndTimes() {
            List<DateTimeRange.Builder> result = _dateTimeRangeListCopier.copyToBuilder(this.endTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndTimes(Collection<DateTimeRange.BuilderImpl> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copyFromBuilder(endTimes);
        }

        @Override
        public final Builder endTimes(Collection<DateTimeRange> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copy(endTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(DateTimeRange... endTimes) {
            endTimes(Arrays.asList(endTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(Consumer<DateTimeRange.Builder>... endTimes) {
            endTimes(Stream.of(endTimes).map(c -> DateTimeRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DateTimeRange.Builder> getLastUpdatedTimes() {
            List<DateTimeRange.Builder> result = _dateTimeRangeListCopier.copyToBuilder(this.lastUpdatedTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastUpdatedTimes(Collection<DateTimeRange.BuilderImpl> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copyFromBuilder(lastUpdatedTimes);
        }

        @Override
        public final Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(DateTimeRange... lastUpdatedTimes) {
            lastUpdatedTimes(Arrays.asList(lastUpdatedTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder>... lastUpdatedTimes) {
            lastUpdatedTimes(Stream.of(lastUpdatedTimes).map(c -> DateTimeRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEntityArns() {
            if (entityArns instanceof SdkAutoConstructList) {
                return null;
            }
            return entityArns;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        @Override
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityArns(String... entityArns) {
            entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final Collection<String> getEntityValues() {
            if (entityValues instanceof SdkAutoConstructList) {
                return null;
            }
            return entityValues;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        @Override
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityValues(String... entityValues) {
            entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final Collection<String> getEventTypeCategories() {
            if (eventTypeCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return eventTypeCategories;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        @Override
        public final Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategoriesWithStrings(String... eventTypeCategories) {
            eventTypeCategoriesWithStrings(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        public final Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copyEnumToString(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory... eventTypeCategories) {
            eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        public final Collection<? extends Map<String, String>> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags;
        }

        public final void setTags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
        }

        @Override
        public final Builder tags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Map<String, String>... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final Collection<String> getEventStatusCodes() {
            if (eventStatusCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return eventStatusCodes;
        }

        public final void setEventStatusCodes(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
        }

        @Override
        public final Builder eventStatusCodesWithStrings(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodesWithStrings(String... eventStatusCodes) {
            eventStatusCodesWithStrings(Arrays.asList(eventStatusCodes));
            return this;
        }

        @Override
        public final Builder eventStatusCodes(Collection<EventStatusCode> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copyEnumToString(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodes(EventStatusCode... eventStatusCodes) {
            eventStatusCodes(Arrays.asList(eventStatusCodes));
            return this;
        }

        @Override
        public EventFilter build() {
            return new EventFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
