/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.health.DefaultHealthBaseClientBuilder;
import software.amazon.awssdk.services.health.DefaultHealthClient;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.HealthClientBuilder;
import software.amazon.awssdk.services.health.HealthServiceClientConfiguration;
import software.amazon.awssdk.services.health.endpoints.HealthEndpointProvider;

@SdkInternalApi
final class DefaultHealthClientBuilder
extends DefaultHealthBaseClientBuilder<HealthClientBuilder, HealthClient>
implements HealthClientBuilder {
    DefaultHealthClientBuilder() {
    }

    @Override
    public DefaultHealthClientBuilder endpointProvider(HealthEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final HealthClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultHealthClientBuilder.validateClientOptions(clientConfiguration);
        HealthServiceClientConfiguration serviceClientConfiguration = HealthServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultHealthClient(serviceClientConfiguration, clientConfiguration);
    }
}

