/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.health.DefaultHealthBaseClientBuilder;
import software.amazon.awssdk.services.health.DefaultHealthClient;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.HealthClientBuilder;
import software.amazon.awssdk.services.health.HealthServiceClientConfiguration;
import software.amazon.awssdk.services.health.endpoints.HealthEndpointProvider;

@SdkInternalApi
final class DefaultHealthClientBuilder
extends DefaultHealthBaseClientBuilder<HealthClientBuilder, HealthClient>
implements HealthClientBuilder {
    DefaultHealthClientBuilder() {
    }

    @Override
    public DefaultHealthClientBuilder endpointProvider(HealthEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final HealthClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultHealthClientBuilder.validateClientOptions(clientConfiguration);
        HealthServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultHealthClient client = new DefaultHealthClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private HealthServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return HealthServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

