/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EventType;
import software.amazon.awssdk.services.health.model.EventTypeListCopier;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventTypesResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeEventTypesResponse> {
    private static final SdkField<List<EventType>> EVENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventTypes").getter(DescribeEventTypesResponse.getter(DescribeEventTypesResponse::eventTypes)).setter(DescribeEventTypesResponse.setter(Builder::eventTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeEventTypesResponse.getter(DescribeEventTypesResponse::nextToken)).setter(DescribeEventTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private final List<EventType> eventTypes;
    private final String nextToken;

    private DescribeEventTypesResponse(BuilderImpl builder) {
        super(builder);
        this.eventTypes = builder.eventTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventTypes() {
        return this.eventTypes != null && !(this.eventTypes instanceof SdkAutoConstructList);
    }

    public final List<EventType> eventTypes() {
        return this.eventTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTypes() ? this.eventTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTypesResponse)) {
            return false;
        }
        DescribeEventTypesResponse other = (DescribeEventTypesResponse)((Object)obj);
        return this.hasEventTypes() == other.hasEventTypes() && Objects.equals(this.eventTypes(), other.eventTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventTypesResponse").add("EventTypes", this.hasEventTypes() ? this.eventTypes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypes": {
                return Optional.ofNullable(clazz.cast(this.eventTypes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventTypesResponse, T> g) {
        return obj -> g.apply((DescribeEventTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<EventType> eventTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTypesResponse model) {
            super(model);
            this.eventTypes(model.eventTypes);
            this.nextToken(model.nextToken);
        }

        public final List<EventType.Builder> getEventTypes() {
            List<EventType.Builder> result = EventTypeListCopier.copyToBuilder(this.eventTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTypes(Collection<EventType.BuilderImpl> eventTypes) {
            this.eventTypes = EventTypeListCopier.copyFromBuilder(eventTypes);
        }

        @Override
        @Transient
        public final Builder eventTypes(Collection<EventType> eventTypes) {
            this.eventTypes = EventTypeListCopier.copy(eventTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypes(EventType ... eventTypes) {
            this.eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypes(Consumer<EventType.Builder> ... eventTypes) {
            this.eventTypes(Stream.of(eventTypes).map(c -> (EventType)((EventType.Builder)EventType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeEventTypesResponse build() {
            return new DescribeEventTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventTypesResponse> {
        public Builder eventTypes(Collection<EventType> var1);

        public Builder eventTypes(EventType ... var1);

        public Builder eventTypes(Consumer<EventType.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

