/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateTimeRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateTimeRange> {
    private static final SdkField<Instant> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("from").getter(DateTimeRange.getter(DateTimeRange::from)).setter(DateTimeRange.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()}).build();
    private static final SdkField<Instant> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("to").getter(DateTimeRange.getter(DateTimeRange::to)).setter(DateTimeRange.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, TO_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant from;
    private final Instant to;

    private DateTimeRange(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
    }

    public final Instant from() {
        return this.from;
    }

    public final Instant to() {
        return this.to;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRange)) {
            return false;
        }
        DateTimeRange other = (DateTimeRange)obj;
        return Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to());
    }

    public final String toString() {
        return ToString.builder((String)"DateTimeRange").add("From", (Object)this.from()).add("To", (Object)this.to()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "from": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "to": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateTimeRange, T> g) {
        return obj -> g.apply((DateTimeRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant from;
        private Instant to;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeRange model) {
            this.from(model.from);
            this.to(model.to);
        }

        public final Instant getFrom() {
            return this.from;
        }

        public final void setFrom(Instant from) {
            this.from = from;
        }

        @Override
        @Transient
        public final Builder from(Instant from) {
            this.from = from;
            return this;
        }

        public final Instant getTo() {
            return this.to;
        }

        public final void setTo(Instant to) {
            this.to = to;
        }

        @Override
        @Transient
        public final Builder to(Instant to) {
            this.to = to;
            return this;
        }

        public DateTimeRange build() {
            return new DateTimeRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateTimeRange> {
        public Builder from(Instant var1);

        public Builder to(Instant var1);
    }
}

