/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EntityStatusCode {
    IMPAIRED("IMPAIRED"),
    UNIMPAIRED("UNIMPAIRED"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EntityStatusCode> VALUE_MAP;
    private final String value;

    private EntityStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntityStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntityStatusCode> knownValues() {
        EnumSet<EntityStatusCode> knownValues = EnumSet.allOf(EntityStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EntityStatusCode.class, EntityStatusCode::toString);
    }
}

