/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EntityStatusCode {
    IMPAIRED("IMPAIRED"),
    UNIMPAIRED("UNIMPAIRED"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EntityStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntityStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EntityStatusCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntityStatusCode> knownValues() {
        return Stream.of(EntityStatusCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

