/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.health.model.Event;
import software.amazon.awssdk.services.health.model.EventDescription;
import software.amazon.awssdk.services.health.model._eventMetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventDetails> {
    private static final SdkField<Event> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("event").getter(EventDetails.getter(EventDetails::event)).setter(EventDetails.setter(Builder::event)).constructor(Event::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()}).build();
    private static final SdkField<EventDescription> EVENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventDescription").getter(EventDetails.getter(EventDetails::eventDescription)).setter(EventDetails.setter(Builder::eventDescription)).constructor(EventDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDescription").build()}).build();
    private static final SdkField<Map<String, String>> EVENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("eventMetadata").getter(EventDetails.getter(EventDetails::eventMetadata)).setter(EventDetails.setter(Builder::eventMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD, EVENT_DESCRIPTION_FIELD, EVENT_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final Event event;
    private final EventDescription eventDescription;
    private final Map<String, String> eventMetadata;

    private EventDetails(BuilderImpl builder) {
        this.event = builder.event;
        this.eventDescription = builder.eventDescription;
        this.eventMetadata = builder.eventMetadata;
    }

    public Event event() {
        return this.event;
    }

    public EventDescription eventDescription() {
        return this.eventDescription;
    }

    public boolean hasEventMetadata() {
        return this.eventMetadata != null && !(this.eventMetadata instanceof SdkAutoConstructMap);
    }

    public Map<String, String> eventMetadata() {
        return this.eventMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventMetadata() ? this.eventMetadata() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDetails)) {
            return false;
        }
        EventDetails other = (EventDetails)obj;
        return Objects.equals(this.event(), other.event()) && Objects.equals(this.eventDescription(), other.eventDescription()) && this.hasEventMetadata() == other.hasEventMetadata() && Objects.equals(this.eventMetadata(), other.eventMetadata());
    }

    public String toString() {
        return ToString.builder((String)"EventDetails").add("Event", (Object)this.event()).add("EventDescription", (Object)this.eventDescription()).add("EventMetadata", this.hasEventMetadata() ? this.eventMetadata() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "event": {
                return Optional.ofNullable(clazz.cast(this.event()));
            }
            case "eventDescription": {
                return Optional.ofNullable(clazz.cast(this.eventDescription()));
            }
            case "eventMetadata": {
                return Optional.ofNullable(clazz.cast(this.eventMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventDetails, T> g) {
        return obj -> g.apply((EventDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Event event;
        private EventDescription eventDescription;
        private Map<String, String> eventMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventDetails model) {
            this.event(model.event);
            this.eventDescription(model.eventDescription);
            this.eventMetadata(model.eventMetadata);
        }

        public final Event.Builder getEvent() {
            return this.event != null ? this.event.toBuilder() : null;
        }

        @Override
        public final Builder event(Event event) {
            this.event = event;
            return this;
        }

        public final void setEvent(Event.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        public final EventDescription.Builder getEventDescription() {
            return this.eventDescription != null ? this.eventDescription.toBuilder() : null;
        }

        @Override
        public final Builder eventDescription(EventDescription eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        public final void setEventDescription(EventDescription.BuilderImpl eventDescription) {
            this.eventDescription = eventDescription != null ? eventDescription.build() : null;
        }

        public final Map<String, String> getEventMetadata() {
            if (this.eventMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.eventMetadata;
        }

        @Override
        public final Builder eventMetadata(Map<String, String> eventMetadata) {
            this.eventMetadata = _eventMetadataCopier.copy(eventMetadata);
            return this;
        }

        public final void setEventMetadata(Map<String, String> eventMetadata) {
            this.eventMetadata = _eventMetadataCopier.copy(eventMetadata);
        }

        public EventDetails build() {
            return new EventDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventDetails> {
        public Builder event(Event var1);

        default public Builder event(Consumer<Event.Builder> event) {
            return this.event((Event)((Event.Builder)Event.builder().applyMutation(event)).build());
        }

        public Builder eventDescription(EventDescription var1);

        default public Builder eventDescription(Consumer<EventDescription.Builder> eventDescription) {
            return this.eventDescription((EventDescription)((EventDescription.Builder)EventDescription.builder().applyMutation(eventDescription)).build());
        }

        public Builder eventMetadata(Map<String, String> var1);
    }
}

