/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.DateTimeRange;
import software.amazon.awssdk.services.health.model.EventStatusCode;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.model._awsAccountIdsListCopier;
import software.amazon.awssdk.services.health.model._entityArnListCopier;
import software.amazon.awssdk.services.health.model._entityValueListCopier;
import software.amazon.awssdk.services.health.model._eventStatusCodeListCopier;
import software.amazon.awssdk.services.health.model._eventTypeCategoryListCopier;
import software.amazon.awssdk.services.health.model._eventTypeListCopier;
import software.amazon.awssdk.services.health.model._regionListCopier;
import software.amazon.awssdk.services.health.model._serviceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationEventFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationEventFilter> {
    private static final SdkField<List<String>> EVENT_TYPE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrganizationEventFilter.getter(OrganizationEventFilter::eventTypeCodes)).setter(OrganizationEventFilter.setter(Builder::eventTypeCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrganizationEventFilter.getter(OrganizationEventFilter::awsAccountIds)).setter(OrganizationEventFilter.setter(Builder::awsAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrganizationEventFilter.getter(OrganizationEventFilter::services)).setter(OrganizationEventFilter.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrganizationEventFilter.getter(OrganizationEventFilter::regions)).setter(OrganizationEventFilter.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DateTimeRange> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OrganizationEventFilter.getter(OrganizationEventFilter::startTime)).setter(OrganizationEventFilter.setter(Builder::startTime)).constructor(DateTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<DateTimeRange> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OrganizationEventFilter.getter(OrganizationEventFilter::endTime)).setter(OrganizationEventFilter.setter(Builder::endTime)).constructor(DateTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<DateTimeRange> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OrganizationEventFilter.getter(OrganizationEventFilter::lastUpdatedTime)).setter(OrganizationEventFilter.setter(Builder::lastUpdatedTime)).constructor(DateTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<List<String>> ENTITY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrganizationEventFilter.getter(OrganizationEventFilter::entityArns)).setter(OrganizationEventFilter.setter(Builder::entityArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENTITY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrganizationEventFilter.getter(OrganizationEventFilter::entityValues)).setter(OrganizationEventFilter.setter(Builder::entityValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENT_TYPE_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrganizationEventFilter.getter(OrganizationEventFilter::eventTypeCategoriesAsStrings)).setter(OrganizationEventFilter.setter(Builder::eventTypeCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENT_STATUS_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OrganizationEventFilter.getter(OrganizationEventFilter::eventStatusCodesAsStrings)).setter(OrganizationEventFilter.setter(Builder::eventStatusCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatusCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_CODES_FIELD, AWS_ACCOUNT_IDS_FIELD, SERVICES_FIELD, REGIONS_FIELD, START_TIME_FIELD, END_TIME_FIELD, LAST_UPDATED_TIME_FIELD, ENTITY_ARNS_FIELD, ENTITY_VALUES_FIELD, EVENT_TYPE_CATEGORIES_FIELD, EVENT_STATUS_CODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> eventTypeCodes;
    private final List<String> awsAccountIds;
    private final List<String> services;
    private final List<String> regions;
    private final DateTimeRange startTime;
    private final DateTimeRange endTime;
    private final DateTimeRange lastUpdatedTime;
    private final List<String> entityArns;
    private final List<String> entityValues;
    private final List<String> eventTypeCategories;
    private final List<String> eventStatusCodes;

    private OrganizationEventFilter(BuilderImpl builder) {
        this.eventTypeCodes = builder.eventTypeCodes;
        this.awsAccountIds = builder.awsAccountIds;
        this.services = builder.services;
        this.regions = builder.regions;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.eventTypeCategories = builder.eventTypeCategories;
        this.eventStatusCodes = builder.eventStatusCodes;
    }

    public boolean hasEventTypeCodes() {
        return this.eventTypeCodes != null && !(this.eventTypeCodes instanceof SdkAutoConstructList);
    }

    public List<String> eventTypeCodes() {
        return this.eventTypeCodes;
    }

    public boolean hasAwsAccountIds() {
        return this.awsAccountIds != null && !(this.awsAccountIds instanceof SdkAutoConstructList);
    }

    public List<String> awsAccountIds() {
        return this.awsAccountIds;
    }

    public boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public List<String> services() {
        return this.services;
    }

    public boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public List<String> regions() {
        return this.regions;
    }

    public DateTimeRange startTime() {
        return this.startTime;
    }

    public DateTimeRange endTime() {
        return this.endTime;
    }

    public DateTimeRange lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public boolean hasEntityArns() {
        return this.entityArns != null && !(this.entityArns instanceof SdkAutoConstructList);
    }

    public List<String> entityArns() {
        return this.entityArns;
    }

    public boolean hasEntityValues() {
        return this.entityValues != null && !(this.entityValues instanceof SdkAutoConstructList);
    }

    public List<String> entityValues() {
        return this.entityValues;
    }

    public List<EventTypeCategory> eventTypeCategories() {
        return _eventTypeCategoryListCopier.copyStringToEnum(this.eventTypeCategories);
    }

    public boolean hasEventTypeCategories() {
        return this.eventTypeCategories != null && !(this.eventTypeCategories instanceof SdkAutoConstructList);
    }

    public List<String> eventTypeCategoriesAsStrings() {
        return this.eventTypeCategories;
    }

    public List<EventStatusCode> eventStatusCodes() {
        return _eventStatusCodeListCopier.copyStringToEnum(this.eventStatusCodes);
    }

    public boolean hasEventStatusCodes() {
        return this.eventStatusCodes != null && !(this.eventStatusCodes instanceof SdkAutoConstructList);
    }

    public List<String> eventStatusCodesAsStrings() {
        return this.eventStatusCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        hashCode = 31 * hashCode + Objects.hashCode(this.regions());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCategoriesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusCodesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationEventFilter)) {
            return false;
        }
        OrganizationEventFilter other = (OrganizationEventFilter)obj;
        return Objects.equals(this.eventTypeCodes(), other.eventTypeCodes()) && Objects.equals(this.awsAccountIds(), other.awsAccountIds()) && Objects.equals(this.services(), other.services()) && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.entityArns(), other.entityArns()) && Objects.equals(this.entityValues(), other.entityValues()) && Objects.equals(this.eventTypeCategoriesAsStrings(), other.eventTypeCategoriesAsStrings()) && Objects.equals(this.eventStatusCodesAsStrings(), other.eventStatusCodesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"OrganizationEventFilter").add("EventTypeCodes", this.eventTypeCodes()).add("AwsAccountIds", this.awsAccountIds()).add("Services", this.services()).add("Regions", this.regions()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("EntityArns", this.entityArns()).add("EntityValues", this.entityValues()).add("EventTypeCategories", this.eventTypeCategoriesAsStrings()).add("EventStatusCodes", this.eventStatusCodesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypeCodes": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCodes()));
            }
            case "awsAccountIds": {
                return Optional.ofNullable(clazz.cast(this.awsAccountIds()));
            }
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "entityArns": {
                return Optional.ofNullable(clazz.cast(this.entityArns()));
            }
            case "entityValues": {
                return Optional.ofNullable(clazz.cast(this.entityValues()));
            }
            case "eventTypeCategories": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCategoriesAsStrings()));
            }
            case "eventStatusCodes": {
                return Optional.ofNullable(clazz.cast(this.eventStatusCodesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationEventFilter, T> g) {
        return obj -> g.apply((OrganizationEventFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventTypeCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> services = DefaultSdkAutoConstructList.getInstance();
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private DateTimeRange startTime;
        private DateTimeRange endTime;
        private DateTimeRange lastUpdatedTime;
        private List<String> entityArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> entityValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> eventTypeCategories = DefaultSdkAutoConstructList.getInstance();
        private List<String> eventStatusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationEventFilter model) {
            this.eventTypeCodes(model.eventTypeCodes);
            this.awsAccountIds(model.awsAccountIds);
            this.services(model.services);
            this.regions(model.regions);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.entityArns(model.entityArns);
            this.entityValues(model.entityValues);
            this.eventTypeCategoriesWithStrings(model.eventTypeCategories);
            this.eventStatusCodesWithStrings(model.eventStatusCodes);
        }

        public final Collection<String> getEventTypeCodes() {
            return this.eventTypeCodes;
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String ... eventTypeCodes) {
            this.eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
        }

        public final Collection<String> getAwsAccountIds() {
            return this.awsAccountIds;
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = _awsAccountIdsListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String ... awsAccountIds) {
            this.awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final void setAwsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = _awsAccountIdsListCopier.copy(awsAccountIds);
        }

        public final Collection<String> getServices() {
            return this.services;
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        public final Collection<String> getRegions() {
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
        }

        public final DateTimeRange.Builder getStartTime() {
            return this.startTime != null ? this.startTime.toBuilder() : null;
        }

        @Override
        public final Builder startTime(DateTimeRange startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(DateTimeRange.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        public final DateTimeRange.Builder getEndTime() {
            return this.endTime != null ? this.endTime.toBuilder() : null;
        }

        @Override
        public final Builder endTime(DateTimeRange endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(DateTimeRange.BuilderImpl endTime) {
            this.endTime = endTime != null ? endTime.build() : null;
        }

        public final DateTimeRange.Builder getLastUpdatedTime() {
            return this.lastUpdatedTime != null ? this.lastUpdatedTime.toBuilder() : null;
        }

        @Override
        public final Builder lastUpdatedTime(DateTimeRange lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(DateTimeRange.BuilderImpl lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime != null ? lastUpdatedTime.build() : null;
        }

        public final Collection<String> getEntityArns() {
            return this.entityArns;
        }

        @Override
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityArns(String ... entityArns) {
            this.entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        public final Collection<String> getEntityValues() {
            return this.entityValues;
        }

        @Override
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityValues(String ... entityValues) {
            this.entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        public final Collection<String> getEventTypeCategories() {
            return this.eventTypeCategories;
        }

        @Override
        public final Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategoriesWithStrings(String ... eventTypeCategories) {
            this.eventTypeCategoriesWithStrings(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        public final Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copyEnumToString(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        public final Collection<String> getEventStatusCodes() {
            return this.eventStatusCodes;
        }

        @Override
        public final Builder eventStatusCodesWithStrings(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodesWithStrings(String ... eventStatusCodes) {
            this.eventStatusCodesWithStrings(Arrays.asList(eventStatusCodes));
            return this;
        }

        @Override
        public final Builder eventStatusCodes(Collection<EventStatusCode> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copyEnumToString(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodes(EventStatusCode ... eventStatusCodes) {
            this.eventStatusCodes(Arrays.asList(eventStatusCodes));
            return this;
        }

        public final void setEventStatusCodes(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
        }

        public OrganizationEventFilter build() {
            return new OrganizationEventFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationEventFilter> {
        public Builder eventTypeCodes(Collection<String> var1);

        public Builder eventTypeCodes(String ... var1);

        public Builder awsAccountIds(Collection<String> var1);

        public Builder awsAccountIds(String ... var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder startTime(DateTimeRange var1);

        default public Builder startTime(Consumer<DateTimeRange.Builder> startTime) {
            return this.startTime((DateTimeRange)((DateTimeRange.Builder)DateTimeRange.builder().applyMutation(startTime)).build());
        }

        public Builder endTime(DateTimeRange var1);

        default public Builder endTime(Consumer<DateTimeRange.Builder> endTime) {
            return this.endTime((DateTimeRange)((DateTimeRange.Builder)DateTimeRange.builder().applyMutation(endTime)).build());
        }

        public Builder lastUpdatedTime(DateTimeRange var1);

        default public Builder lastUpdatedTime(Consumer<DateTimeRange.Builder> lastUpdatedTime) {
            return this.lastUpdatedTime((DateTimeRange)((DateTimeRange.Builder)DateTimeRange.builder().applyMutation(lastUpdatedTime)).build());
        }

        public Builder entityArns(Collection<String> var1);

        public Builder entityArns(String ... var1);

        public Builder entityValues(Collection<String> var1);

        public Builder entityValues(String ... var1);

        public Builder eventTypeCategoriesWithStrings(Collection<String> var1);

        public Builder eventTypeCategoriesWithStrings(String ... var1);

        public Builder eventTypeCategories(Collection<EventTypeCategory> var1);

        public Builder eventTypeCategories(EventTypeCategory ... var1);

        public Builder eventStatusCodesWithStrings(Collection<String> var1);

        public Builder eventStatusCodesWithStrings(String ... var1);

        public Builder eventStatusCodes(Collection<EventStatusCode> var1);

        public Builder eventStatusCodes(EventStatusCode ... var1);
    }
}

