/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.model.ConcurrentModificationException;
import software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse;
import software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEntityAggregatesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsResponse;
import software.amazon.awssdk.services.health.model.DescribeEventTypesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventTypesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DescribeEventsRequest;
import software.amazon.awssdk.services.health.model.DescribeEventsResponse;
import software.amazon.awssdk.services.health.model.DescribeHealthServiceStatusForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeHealthServiceStatusForOrganizationResponse;
import software.amazon.awssdk.services.health.model.DisableHealthServiceAccessForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DisableHealthServiceAccessForOrganizationResponse;
import software.amazon.awssdk.services.health.model.EnableHealthServiceAccessForOrganizationRequest;
import software.amazon.awssdk.services.health.model.EnableHealthServiceAccessForOrganizationResponse;
import software.amazon.awssdk.services.health.model.HealthException;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.services.health.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.health.model.UnsupportedLocaleException;
import software.amazon.awssdk.services.health.paginators.DescribeAffectedAccountsForOrganizationIterable;
import software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesForOrganizationIterable;
import software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventsForOrganizationIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.health.transform.DescribeAffectedAccountsForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeAffectedEntitiesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeAffectedEntitiesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEntityAggregatesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventAggregatesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventDetailsForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventDetailsRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventTypesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventsForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeHealthServiceStatusForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DisableHealthServiceAccessForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.health.transform.EnableHealthServiceAccessForOrganizationRequestMarshaller;

@SdkInternalApi
final class DefaultHealthClient
implements HealthClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultHealthClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "health";
    }

    @Override
    public DescribeAffectedAccountsForOrganizationResponse describeAffectedAccountsForOrganization(DescribeAffectedAccountsForOrganizationRequest describeAffectedAccountsForOrganizationRequest) throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAffectedAccountsForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAffectedAccountsForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAffectedAccountsForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAffectedAccountsForOrganizationRequest).withMarshaller((Marshaller)new DescribeAffectedAccountsForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAffectedAccountsForOrganizationIterable describeAffectedAccountsForOrganizationPaginator(DescribeAffectedAccountsForOrganizationRequest describeAffectedAccountsForOrganizationRequest) throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeAffectedAccountsForOrganizationIterable(this, this.applyPaginatorUserAgent(describeAffectedAccountsForOrganizationRequest));
    }

    @Override
    public DescribeAffectedEntitiesResponse describeAffectedEntities(DescribeAffectedEntitiesRequest describeAffectedEntitiesRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAffectedEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAffectedEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAffectedEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAffectedEntitiesRequest).withMarshaller((Marshaller)new DescribeAffectedEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAffectedEntitiesIterable describeAffectedEntitiesPaginator(DescribeAffectedEntitiesRequest describeAffectedEntitiesRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeAffectedEntitiesIterable(this, this.applyPaginatorUserAgent(describeAffectedEntitiesRequest));
    }

    @Override
    public DescribeAffectedEntitiesForOrganizationResponse describeAffectedEntitiesForOrganization(DescribeAffectedEntitiesForOrganizationRequest describeAffectedEntitiesForOrganizationRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAffectedEntitiesForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAffectedEntitiesForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAffectedEntitiesForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAffectedEntitiesForOrganizationRequest).withMarshaller((Marshaller)new DescribeAffectedEntitiesForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAffectedEntitiesForOrganizationIterable describeAffectedEntitiesForOrganizationPaginator(DescribeAffectedEntitiesForOrganizationRequest describeAffectedEntitiesForOrganizationRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeAffectedEntitiesForOrganizationIterable(this, this.applyPaginatorUserAgent(describeAffectedEntitiesForOrganizationRequest));
    }

    @Override
    public DescribeEntityAggregatesResponse describeEntityAggregates(DescribeEntityAggregatesRequest describeEntityAggregatesRequest) throws AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntityAggregatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEntityAggregatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntityAggregates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEntityAggregatesRequest).withMarshaller((Marshaller)new DescribeEntityAggregatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventAggregatesResponse describeEventAggregates(DescribeEventAggregatesRequest describeEventAggregatesRequest) throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventAggregatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventAggregatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventAggregates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventAggregatesRequest).withMarshaller((Marshaller)new DescribeEventAggregatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventAggregatesIterable describeEventAggregatesPaginator(DescribeEventAggregatesRequest describeEventAggregatesRequest) throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeEventAggregatesIterable(this, this.applyPaginatorUserAgent(describeEventAggregatesRequest));
    }

    @Override
    public DescribeEventDetailsResponse describeEventDetails(DescribeEventDetailsRequest describeEventDetailsRequest) throws UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventDetailsRequest).withMarshaller((Marshaller)new DescribeEventDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventDetailsForOrganizationResponse describeEventDetailsForOrganization(DescribeEventDetailsForOrganizationRequest describeEventDetailsForOrganizationRequest) throws UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventDetailsForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventDetailsForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventDetailsForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventDetailsForOrganizationRequest).withMarshaller((Marshaller)new DescribeEventDetailsForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventTypesResponse describeEventTypes(DescribeEventTypesRequest describeEventTypesRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventTypesRequest).withMarshaller((Marshaller)new DescribeEventTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventTypesIterable describeEventTypesPaginator(DescribeEventTypesRequest describeEventTypesRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeEventTypesIterable(this, this.applyPaginatorUserAgent(describeEventTypesRequest));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public DescribeEventsForOrganizationResponse describeEventsForOrganization(DescribeEventsForOrganizationRequest describeEventsForOrganizationRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEventsForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventsForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsForOrganizationRequest).withMarshaller((Marshaller)new DescribeEventsForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEventsForOrganizationIterable describeEventsForOrganizationPaginator(DescribeEventsForOrganizationRequest describeEventsForOrganizationRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeEventsForOrganizationIterable(this, this.applyPaginatorUserAgent(describeEventsForOrganizationRequest));
    }

    @Override
    public DescribeHealthServiceStatusForOrganizationResponse describeHealthServiceStatusForOrganization(DescribeHealthServiceStatusForOrganizationRequest describeHealthServiceStatusForOrganizationRequest) throws AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHealthServiceStatusForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeHealthServiceStatusForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHealthServiceStatusForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHealthServiceStatusForOrganizationRequest).withMarshaller((Marshaller)new DescribeHealthServiceStatusForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisableHealthServiceAccessForOrganizationResponse disableHealthServiceAccessForOrganization(DisableHealthServiceAccessForOrganizationRequest disableHealthServiceAccessForOrganizationRequest) throws ConcurrentModificationException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableHealthServiceAccessForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisableHealthServiceAccessForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableHealthServiceAccessForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableHealthServiceAccessForOrganizationRequest).withMarshaller((Marshaller)new DisableHealthServiceAccessForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnableHealthServiceAccessForOrganizationResponse enableHealthServiceAccessForOrganization(EnableHealthServiceAccessForOrganizationRequest enableHealthServiceAccessForOrganizationRequest) throws ConcurrentModificationException, AwsServiceException, SdkClientException, HealthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableHealthServiceAccessForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnableHealthServiceAccessForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableHealthServiceAccessForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableHealthServiceAccessForOrganizationRequest).withMarshaller((Marshaller)new EnableHealthServiceAccessForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(HealthException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedLocale").exceptionBuilderSupplier(UnsupportedLocaleException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationToken").exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends HealthRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.51").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((HealthRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

