/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.health.model.EventAggregateField;
import software.amazon.awssdk.services.health.model.EventFilter;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventAggregatesRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeEventAggregatesRequest> {
    private static final SdkField<EventFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeEventAggregatesRequest.getter(DescribeEventAggregatesRequest::filter)).setter(DescribeEventAggregatesRequest.setter(Builder::filter)).constructor(EventFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<String> AGGREGATE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEventAggregatesRequest.getter(DescribeEventAggregatesRequest::aggregateFieldAsString)).setter(DescribeEventAggregatesRequest.setter(Builder::aggregateField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateField").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeEventAggregatesRequest.getter(DescribeEventAggregatesRequest::maxResults)).setter(DescribeEventAggregatesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEventAggregatesRequest.getter(DescribeEventAggregatesRequest::nextToken)).setter(DescribeEventAggregatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, AGGREGATE_FIELD_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final EventFilter filter;
    private final String aggregateField;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeEventAggregatesRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.aggregateField = builder.aggregateField;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public EventFilter filter() {
        return this.filter;
    }

    public EventAggregateField aggregateField() {
        return EventAggregateField.fromValue(this.aggregateField);
    }

    public String aggregateFieldAsString() {
        return this.aggregateField;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateFieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventAggregatesRequest)) {
            return false;
        }
        DescribeEventAggregatesRequest other = (DescribeEventAggregatesRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.aggregateFieldAsString(), other.aggregateFieldAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventAggregatesRequest").add("Filter", (Object)this.filter()).add("AggregateField", (Object)this.aggregateFieldAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "aggregateField": {
                return Optional.ofNullable(clazz.cast(this.aggregateFieldAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventAggregatesRequest, T> g) {
        return obj -> g.apply((DescribeEventAggregatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private EventFilter filter;
        private String aggregateField;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventAggregatesRequest model) {
            super(model);
            this.filter(model.filter);
            this.aggregateField(model.aggregateField);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final EventFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(EventFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(EventFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getAggregateField() {
            return this.aggregateField;
        }

        @Override
        public final Builder aggregateField(String aggregateField) {
            this.aggregateField = aggregateField;
            return this;
        }

        @Override
        public final Builder aggregateField(EventAggregateField aggregateField) {
            this.aggregateField(aggregateField.toString());
            return this;
        }

        public final void setAggregateField(String aggregateField) {
            this.aggregateField = aggregateField;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventAggregatesRequest build() {
            return new DescribeEventAggregatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventAggregatesRequest> {
        public Builder filter(EventFilter var1);

        default public Builder filter(Consumer<EventFilter.Builder> filter) {
            return this.filter((EventFilter)((EventFilter.Builder)EventFilter.builder().applyMutation(filter)).build());
        }

        public Builder aggregateField(String var1);

        public Builder aggregateField(EventAggregateField var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

