/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.model.DescribeEventsRequest;
import software.amazon.awssdk.services.health.model.DescribeEventsResponse;
import software.amazon.awssdk.services.health.model.Event;

public final class DescribeEventsPaginator
implements SdkIterable<DescribeEventsResponse> {
    private final HealthClient client;
    private final DescribeEventsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeEventsPaginator(HealthClient client, DescribeEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventsResponseFetcher();
    }

    public Iterator<DescribeEventsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Event> events() {
        Function<DescribeEventsResponse, Iterator> getIterator = response -> response != null ? response.events().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeEventsResponseFetcher
    implements NextPageFetcher<DescribeEventsResponse> {
        private DescribeEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeEventsResponse nextPage(DescribeEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventsPaginator.this.client.describeEvents(DescribeEventsPaginator.this.firstRequest);
            }
            return DescribeEventsPaginator.this.client.describeEvents((DescribeEventsRequest)((Object)DescribeEventsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

