/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.model.DescribeEventTypesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventTypesResponse;
import software.amazon.awssdk.services.health.model.EventType;

public final class DescribeEventTypesPaginator
implements SdkIterable<DescribeEventTypesResponse> {
    private final HealthClient client;
    private final DescribeEventTypesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeEventTypesPaginator(HealthClient client, DescribeEventTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventTypesResponseFetcher();
    }

    public Iterator<DescribeEventTypesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<EventType> eventTypes() {
        Function<DescribeEventTypesResponse, Iterator> getIterator = response -> response != null ? response.eventTypes().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeEventTypesResponseFetcher
    implements NextPageFetcher<DescribeEventTypesResponse> {
        private DescribeEventTypesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventTypesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeEventTypesResponse nextPage(DescribeEventTypesResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventTypesPaginator.this.client.describeEventTypes(DescribeEventTypesPaginator.this.firstRequest);
            }
            return DescribeEventTypesPaginator.this.client.describeEventTypes((DescribeEventTypesRequest)((Object)DescribeEventTypesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

