/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse;
import software.amazon.awssdk.services.health.model.EventAggregate;

public final class DescribeEventAggregatesPaginator
implements SdkIterable<DescribeEventAggregatesResponse> {
    private final HealthClient client;
    private final DescribeEventAggregatesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeEventAggregatesPaginator(HealthClient client, DescribeEventAggregatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventAggregatesResponseFetcher();
    }

    public Iterator<DescribeEventAggregatesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<EventAggregate> eventAggregates() {
        Function<DescribeEventAggregatesResponse, Iterator> getIterator = response -> response != null ? response.eventAggregates().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeEventAggregatesResponseFetcher
    implements NextPageFetcher<DescribeEventAggregatesResponse> {
        private DescribeEventAggregatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventAggregatesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeEventAggregatesResponse nextPage(DescribeEventAggregatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventAggregatesPaginator.this.client.describeEventAggregates(DescribeEventAggregatesPaginator.this.firstRequest);
            }
            return DescribeEventAggregatesPaginator.this.client.describeEventAggregates((DescribeEventAggregatesRequest)((Object)DescribeEventAggregatesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

