/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.model.AffectedEntity;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse;

public final class DescribeAffectedEntitiesPaginator
implements SdkIterable<DescribeAffectedEntitiesResponse> {
    private final HealthClient client;
    private final DescribeAffectedEntitiesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeAffectedEntitiesPaginator(HealthClient client, DescribeAffectedEntitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAffectedEntitiesResponseFetcher();
    }

    public Iterator<DescribeAffectedEntitiesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<AffectedEntity> entities() {
        Function<DescribeAffectedEntitiesResponse, Iterator> getIterator = response -> response != null ? response.entities().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeAffectedEntitiesResponseFetcher
    implements NextPageFetcher<DescribeAffectedEntitiesResponse> {
        private DescribeAffectedEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAffectedEntitiesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeAffectedEntitiesResponse nextPage(DescribeAffectedEntitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAffectedEntitiesPaginator.this.client.describeAffectedEntities(DescribeAffectedEntitiesPaginator.this.firstRequest);
            }
            return DescribeAffectedEntitiesPaginator.this.client.describeAffectedEntities((DescribeAffectedEntitiesRequest)((Object)DescribeAffectedEntitiesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

