/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.model.EventTypeCategoryListCopier;
import software.amazon.awssdk.services.health.model.EventTypeCodeListCopier;
import software.amazon.awssdk.services.health.model._serviceListCopier;
import software.amazon.awssdk.services.health.transform.EventTypeFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventTypeFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, EventTypeFilter> {
    private final List<String> eventTypeCodes;
    private final List<String> services;
    private final List<String> eventTypeCategories;

    private EventTypeFilter(BuilderImpl builder) {
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.eventTypeCategories = builder.eventTypeCategories;
    }

    public List<String> eventTypeCodes() {
        return this.eventTypeCodes;
    }

    public List<String> services() {
        return this.services;
    }

    public List<EventTypeCategory> eventTypeCategories() {
        return TypeConverter.convert(this.eventTypeCategories, EventTypeCategory::fromValue);
    }

    public List<String> eventTypeCategoriesStrings() {
        return this.eventTypeCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCategoriesStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTypeFilter)) {
            return false;
        }
        EventTypeFilter other = (EventTypeFilter)obj;
        return Objects.equals(this.eventTypeCodes(), other.eventTypeCodes()) && Objects.equals(this.services(), other.services()) && Objects.equals(this.eventTypeCategoriesStrings(), other.eventTypeCategoriesStrings());
    }

    public String toString() {
        return ToString.builder((String)"EventTypeFilter").add("EventTypeCodes", this.eventTypeCodes()).add("Services", this.services()).add("EventTypeCategories", this.eventTypeCategoriesStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypeCodes": {
                return Optional.of(clazz.cast(this.eventTypeCodes()));
            }
            case "services": {
                return Optional.of(clazz.cast(this.services()));
            }
            case "eventTypeCategories": {
                return Optional.of(clazz.cast(this.eventTypeCategoriesStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventTypeFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventTypeCodes;
        private List<String> services;
        private List<String> eventTypeCategories;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTypeFilter model) {
            this.eventTypeCodes(model.eventTypeCodes);
            this.services(model.services);
            this.eventTypeCategories(model.eventTypeCategories);
        }

        public final Collection<String> getEventTypeCodes() {
            return this.eventTypeCodes;
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String ... eventTypeCodes) {
            this.eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
        }

        public final Collection<String> getServices() {
            return this.services;
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        public final Collection<String> getEventTypeCategories() {
            return this.eventTypeCategories;
        }

        @Override
        public final Builder eventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(String ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        public EventTypeFilter build() {
            return new EventTypeFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventTypeFilter> {
        public Builder eventTypeCodes(Collection<String> var1);

        public Builder eventTypeCodes(String ... var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);

        public Builder eventTypeCategories(Collection<String> var1);

        public Builder eventTypeCategories(String ... var1);
    }
}

