/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.health.model.DateTimeRange;
import software.amazon.awssdk.services.health.model.EventStatusCode;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.model._availabilityZonesCopier;
import software.amazon.awssdk.services.health.model._dateTimeRangeListCopier;
import software.amazon.awssdk.services.health.model._entityArnListCopier;
import software.amazon.awssdk.services.health.model._entityValueListCopier;
import software.amazon.awssdk.services.health.model._eventArnListCopier;
import software.amazon.awssdk.services.health.model._eventStatusCodeListCopier;
import software.amazon.awssdk.services.health.model._eventTypeCategoryListCopier;
import software.amazon.awssdk.services.health.model._eventTypeListCopier;
import software.amazon.awssdk.services.health.model._regionListCopier;
import software.amazon.awssdk.services.health.model._serviceListCopier;
import software.amazon.awssdk.services.health.model._tagFilterCopier;
import software.amazon.awssdk.services.health.transform.EventFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, EventFilter> {
    private final List<String> eventArns;
    private final List<String> eventTypeCodes;
    private final List<String> services;
    private final List<String> regions;
    private final List<String> availabilityZones;
    private final List<DateTimeRange> startTimes;
    private final List<DateTimeRange> endTimes;
    private final List<DateTimeRange> lastUpdatedTimes;
    private final List<String> entityArns;
    private final List<String> entityValues;
    private final List<String> eventTypeCategories;
    private final List<Map<String, String>> tags;
    private final List<String> eventStatusCodes;

    private EventFilter(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.regions = builder.regions;
        this.availabilityZones = builder.availabilityZones;
        this.startTimes = builder.startTimes;
        this.endTimes = builder.endTimes;
        this.lastUpdatedTimes = builder.lastUpdatedTimes;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.eventTypeCategories = builder.eventTypeCategories;
        this.tags = builder.tags;
        this.eventStatusCodes = builder.eventStatusCodes;
    }

    public List<String> eventArns() {
        return this.eventArns;
    }

    public List<String> eventTypeCodes() {
        return this.eventTypeCodes;
    }

    public List<String> services() {
        return this.services;
    }

    public List<String> regions() {
        return this.regions;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<DateTimeRange> startTimes() {
        return this.startTimes;
    }

    public List<DateTimeRange> endTimes() {
        return this.endTimes;
    }

    public List<DateTimeRange> lastUpdatedTimes() {
        return this.lastUpdatedTimes;
    }

    public List<String> entityArns() {
        return this.entityArns;
    }

    public List<String> entityValues() {
        return this.entityValues;
    }

    public List<EventTypeCategory> eventTypeCategories() {
        return TypeConverter.convert(this.eventTypeCategories, EventTypeCategory::fromValue);
    }

    public List<String> eventTypeCategoriesStrings() {
        return this.eventTypeCategories;
    }

    public List<Map<String, String>> tags() {
        return this.tags;
    }

    public List<EventStatusCode> eventStatusCodes() {
        return TypeConverter.convert(this.eventStatusCodes, EventStatusCode::fromValue);
    }

    public List<String> eventStatusCodesStrings() {
        return this.eventStatusCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        hashCode = 31 * hashCode + Objects.hashCode(this.regions());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimes());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimes());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCategoriesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusCodesStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter)obj;
        return Objects.equals(this.eventArns(), other.eventArns()) && Objects.equals(this.eventTypeCodes(), other.eventTypeCodes()) && Objects.equals(this.services(), other.services()) && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.startTimes(), other.startTimes()) && Objects.equals(this.endTimes(), other.endTimes()) && Objects.equals(this.lastUpdatedTimes(), other.lastUpdatedTimes()) && Objects.equals(this.entityArns(), other.entityArns()) && Objects.equals(this.entityValues(), other.entityValues()) && Objects.equals(this.eventTypeCategoriesStrings(), other.eventTypeCategoriesStrings()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.eventStatusCodesStrings(), other.eventStatusCodesStrings());
    }

    public String toString() {
        return ToString.builder((String)"EventFilter").add("EventArns", this.eventArns()).add("EventTypeCodes", this.eventTypeCodes()).add("Services", this.services()).add("Regions", this.regions()).add("AvailabilityZones", this.availabilityZones()).add("StartTimes", this.startTimes()).add("EndTimes", this.endTimes()).add("LastUpdatedTimes", this.lastUpdatedTimes()).add("EntityArns", this.entityArns()).add("EntityValues", this.entityValues()).add("EventTypeCategories", this.eventTypeCategoriesStrings()).add("Tags", this.tags()).add("EventStatusCodes", this.eventStatusCodesStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.of(clazz.cast(this.eventArns()));
            }
            case "eventTypeCodes": {
                return Optional.of(clazz.cast(this.eventTypeCodes()));
            }
            case "services": {
                return Optional.of(clazz.cast(this.services()));
            }
            case "regions": {
                return Optional.of(clazz.cast(this.regions()));
            }
            case "availabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
            case "startTimes": {
                return Optional.of(clazz.cast(this.startTimes()));
            }
            case "endTimes": {
                return Optional.of(clazz.cast(this.endTimes()));
            }
            case "lastUpdatedTimes": {
                return Optional.of(clazz.cast(this.lastUpdatedTimes()));
            }
            case "entityArns": {
                return Optional.of(clazz.cast(this.entityArns()));
            }
            case "entityValues": {
                return Optional.of(clazz.cast(this.entityValues()));
            }
            case "eventTypeCategories": {
                return Optional.of(clazz.cast(this.eventTypeCategoriesStrings()));
            }
            case "tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "eventStatusCodes": {
                return Optional.of(clazz.cast(this.eventStatusCodesStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventArns;
        private List<String> eventTypeCodes;
        private List<String> services;
        private List<String> regions;
        private List<String> availabilityZones;
        private List<DateTimeRange> startTimes;
        private List<DateTimeRange> endTimes;
        private List<DateTimeRange> lastUpdatedTimes;
        private List<String> entityArns;
        private List<String> entityValues;
        private List<String> eventTypeCategories;
        private List<Map<String, String>> tags;
        private List<String> eventStatusCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(EventFilter model) {
            this.eventArns(model.eventArns);
            this.eventTypeCodes(model.eventTypeCodes);
            this.services(model.services);
            this.regions(model.regions);
            this.availabilityZones(model.availabilityZones);
            this.startTimes(model.startTimes);
            this.endTimes(model.endTimes);
            this.lastUpdatedTimes(model.lastUpdatedTimes);
            this.entityArns(model.entityArns);
            this.entityValues(model.entityValues);
            this.eventTypeCategories(model.eventTypeCategories);
            this.tags(model.tags);
            this.eventStatusCodes(model.eventStatusCodes);
        }

        public final Collection<String> getEventArns() {
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        public final Collection<String> getEventTypeCodes() {
            return this.eventTypeCodes;
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String ... eventTypeCodes) {
            this.eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
        }

        public final Collection<String> getServices() {
            return this.services;
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        public final Collection<String> getRegions() {
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<DateTimeRange.Builder> getStartTimes() {
            return this.startTimes != null ? (Collection)this.startTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder startTimes(Collection<DateTimeRange> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copy(startTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startTimes(DateTimeRange ... startTimes) {
            this.startTimes(Arrays.asList(startTimes));
            return this;
        }

        public final void setStartTimes(Collection<DateTimeRange.BuilderImpl> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copyFromBuilder(startTimes);
        }

        public final Collection<DateTimeRange.Builder> getEndTimes() {
            return this.endTimes != null ? (Collection)this.endTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endTimes(Collection<DateTimeRange> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copy(endTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(DateTimeRange ... endTimes) {
            this.endTimes(Arrays.asList(endTimes));
            return this;
        }

        public final void setEndTimes(Collection<DateTimeRange.BuilderImpl> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copyFromBuilder(endTimes);
        }

        public final Collection<DateTimeRange.Builder> getLastUpdatedTimes() {
            return this.lastUpdatedTimes != null ? (Collection)this.lastUpdatedTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(DateTimeRange ... lastUpdatedTimes) {
            this.lastUpdatedTimes(Arrays.asList(lastUpdatedTimes));
            return this;
        }

        public final void setLastUpdatedTimes(Collection<DateTimeRange.BuilderImpl> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copyFromBuilder(lastUpdatedTimes);
        }

        public final Collection<String> getEntityArns() {
            return this.entityArns;
        }

        @Override
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityArns(String ... entityArns) {
            this.entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        public final Collection<String> getEntityValues() {
            return this.entityValues;
        }

        @Override
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityValues(String ... entityValues) {
            this.entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        public final Collection<String> getEventTypeCategories() {
            return this.eventTypeCategories;
        }

        @Override
        public final Builder eventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(String ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        public final Collection<Map<String, String>> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Map<String, String> ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
        }

        public final Collection<String> getEventStatusCodes() {
            return this.eventStatusCodes;
        }

        @Override
        public final Builder eventStatusCodes(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodes(String ... eventStatusCodes) {
            this.eventStatusCodes(Arrays.asList(eventStatusCodes));
            return this;
        }

        public final void setEventStatusCodes(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
        }

        public EventFilter build() {
            return new EventFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventFilter> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder eventTypeCodes(Collection<String> var1);

        public Builder eventTypeCodes(String ... var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder startTimes(Collection<DateTimeRange> var1);

        public Builder startTimes(DateTimeRange ... var1);

        public Builder endTimes(Collection<DateTimeRange> var1);

        public Builder endTimes(DateTimeRange ... var1);

        public Builder lastUpdatedTimes(Collection<DateTimeRange> var1);

        public Builder lastUpdatedTimes(DateTimeRange ... var1);

        public Builder entityArns(Collection<String> var1);

        public Builder entityArns(String ... var1);

        public Builder entityValues(Collection<String> var1);

        public Builder entityValues(String ... var1);

        public Builder eventTypeCategories(Collection<String> var1);

        public Builder eventTypeCategories(String ... var1);

        public Builder tags(Collection<Map<String, String>> var1);

        public Builder tags(Map<String, String> ... var1);

        public Builder eventStatusCodes(Collection<String> var1);

        public Builder eventStatusCodes(String ... var1);
    }
}

