/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.transform.EventDetailsErrorItemMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventDetailsErrorItem
implements StructuredPojo,
ToCopyableBuilder<Builder, EventDetailsErrorItem> {
    private final String eventArn;
    private final String errorName;
    private final String errorMessage;

    private EventDetailsErrorItem(BuilderImpl builder) {
        this.eventArn = builder.eventArn;
        this.errorName = builder.errorName;
        this.errorMessage = builder.errorMessage;
    }

    public String eventArn() {
        return this.eventArn;
    }

    public String errorName() {
        return this.errorName;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDetailsErrorItem)) {
            return false;
        }
        EventDetailsErrorItem other = (EventDetailsErrorItem)obj;
        return Objects.equals(this.eventArn(), other.eventArn()) && Objects.equals(this.errorName(), other.errorName()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public String toString() {
        return ToString.builder((String)"EventDetailsErrorItem").add("EventArn", (Object)this.eventArn()).add("ErrorName", (Object)this.errorName()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArn": {
                return Optional.of(clazz.cast(this.eventArn()));
            }
            case "errorName": {
                return Optional.of(clazz.cast(this.errorName()));
            }
            case "errorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventDetailsErrorItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventArn;
        private String errorName;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDetailsErrorItem model) {
            this.eventArn(model.eventArn);
            this.errorName(model.errorName);
            this.errorMessage(model.errorMessage);
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        public final String getErrorName() {
            return this.errorName;
        }

        @Override
        public final Builder errorName(String errorName) {
            this.errorName = errorName;
            return this;
        }

        public final void setErrorName(String errorName) {
            this.errorName = errorName;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public EventDetailsErrorItem build() {
            return new EventDetailsErrorItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventDetailsErrorItem> {
        public Builder eventArn(String var1);

        public Builder errorName(String var1);

        public Builder errorMessage(String var1);
    }
}

