/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.Event;
import software.amazon.awssdk.services.health.model.EventDescription;
import software.amazon.awssdk.services.health.model._eventMetadataCopier;
import software.amazon.awssdk.services.health.transform.EventDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, EventDetails> {
    private final Event event;
    private final EventDescription eventDescription;
    private final Map<String, String> eventMetadata;

    private EventDetails(BuilderImpl builder) {
        this.event = builder.event;
        this.eventDescription = builder.eventDescription;
        this.eventMetadata = builder.eventMetadata;
    }

    public Event event() {
        return this.event;
    }

    public EventDescription eventDescription() {
        return this.eventDescription;
    }

    public Map<String, String> eventMetadata() {
        return this.eventMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDetails)) {
            return false;
        }
        EventDetails other = (EventDetails)obj;
        return Objects.equals(this.event(), other.event()) && Objects.equals(this.eventDescription(), other.eventDescription()) && Objects.equals(this.eventMetadata(), other.eventMetadata());
    }

    public String toString() {
        return ToString.builder((String)"EventDetails").add("Event", (Object)this.event()).add("EventDescription", (Object)this.eventDescription()).add("EventMetadata", this.eventMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "event": {
                return Optional.of(clazz.cast(this.event()));
            }
            case "eventDescription": {
                return Optional.of(clazz.cast(this.eventDescription()));
            }
            case "eventMetadata": {
                return Optional.of(clazz.cast(this.eventMetadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Event event;
        private EventDescription eventDescription;
        private Map<String, String> eventMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDetails model) {
            this.event(model.event);
            this.eventDescription(model.eventDescription);
            this.eventMetadata(model.eventMetadata);
        }

        public final Event.Builder getEvent() {
            return this.event != null ? this.event.toBuilder() : null;
        }

        @Override
        public final Builder event(Event event) {
            this.event = event;
            return this;
        }

        public final void setEvent(Event.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        public final EventDescription.Builder getEventDescription() {
            return this.eventDescription != null ? this.eventDescription.toBuilder() : null;
        }

        @Override
        public final Builder eventDescription(EventDescription eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        public final void setEventDescription(EventDescription.BuilderImpl eventDescription) {
            this.eventDescription = eventDescription != null ? eventDescription.build() : null;
        }

        public final Map<String, String> getEventMetadata() {
            return this.eventMetadata;
        }

        @Override
        public final Builder eventMetadata(Map<String, String> eventMetadata) {
            this.eventMetadata = _eventMetadataCopier.copy(eventMetadata);
            return this;
        }

        public final void setEventMetadata(Map<String, String> eventMetadata) {
            this.eventMetadata = _eventMetadataCopier.copy(eventMetadata);
        }

        public EventDetails build() {
            return new EventDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventDetails> {
        public Builder event(Event var1);

        default public Builder event(Consumer<Event.Builder> event) {
            return this.event((Event)((Event.Builder)Event.builder().apply(event)).build());
        }

        public Builder eventDescription(EventDescription var1);

        default public Builder eventDescription(Consumer<EventDescription.Builder> eventDescription) {
            return this.eventDescription((EventDescription)((EventDescription.Builder)EventDescription.builder().apply(eventDescription)).build());
        }

        public Builder eventMetadata(Map<String, String> var1);
    }
}

