/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.health.model.DateTimeRange;
import software.amazon.awssdk.services.health.model.EntityStatusCode;
import software.amazon.awssdk.services.health.model._dateTimeRangeListCopier;
import software.amazon.awssdk.services.health.model._entityArnListCopier;
import software.amazon.awssdk.services.health.model._entityStatusCodeListCopier;
import software.amazon.awssdk.services.health.model._entityValueListCopier;
import software.amazon.awssdk.services.health.model._eventArnListCopier;
import software.amazon.awssdk.services.health.model._tagFilterCopier;
import software.amazon.awssdk.services.health.transform.EntityFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EntityFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, EntityFilter> {
    private final List<String> eventArns;
    private final List<String> entityArns;
    private final List<String> entityValues;
    private final List<DateTimeRange> lastUpdatedTimes;
    private final List<Map<String, String>> tags;
    private final List<String> statusCodes;

    private EntityFilter(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.lastUpdatedTimes = builder.lastUpdatedTimes;
        this.tags = builder.tags;
        this.statusCodes = builder.statusCodes;
    }

    public List<String> eventArns() {
        return this.eventArns;
    }

    public List<String> entityArns() {
        return this.entityArns;
    }

    public List<String> entityValues() {
        return this.entityValues;
    }

    public List<DateTimeRange> lastUpdatedTimes() {
        return this.lastUpdatedTimes;
    }

    public List<Map<String, String>> tags() {
        return this.tags;
    }

    public List<EntityStatusCode> statusCodes() {
        return TypeConverter.convert(this.statusCodes, EntityStatusCode::fromValue);
    }

    public List<String> statusCodesStrings() {
        return this.statusCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodesStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityFilter)) {
            return false;
        }
        EntityFilter other = (EntityFilter)obj;
        return Objects.equals(this.eventArns(), other.eventArns()) && Objects.equals(this.entityArns(), other.entityArns()) && Objects.equals(this.entityValues(), other.entityValues()) && Objects.equals(this.lastUpdatedTimes(), other.lastUpdatedTimes()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.statusCodesStrings(), other.statusCodesStrings());
    }

    public String toString() {
        return ToString.builder((String)"EntityFilter").add("EventArns", this.eventArns()).add("EntityArns", this.entityArns()).add("EntityValues", this.entityValues()).add("LastUpdatedTimes", this.lastUpdatedTimes()).add("Tags", this.tags()).add("StatusCodes", this.statusCodesStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.of(clazz.cast(this.eventArns()));
            }
            case "entityArns": {
                return Optional.of(clazz.cast(this.entityArns()));
            }
            case "entityValues": {
                return Optional.of(clazz.cast(this.entityValues()));
            }
            case "lastUpdatedTimes": {
                return Optional.of(clazz.cast(this.lastUpdatedTimes()));
            }
            case "tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "statusCodes": {
                return Optional.of(clazz.cast(this.statusCodesStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventArns;
        private List<String> entityArns;
        private List<String> entityValues;
        private List<DateTimeRange> lastUpdatedTimes;
        private List<Map<String, String>> tags;
        private List<String> statusCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityFilter model) {
            this.eventArns(model.eventArns);
            this.entityArns(model.entityArns);
            this.entityValues(model.entityValues);
            this.lastUpdatedTimes(model.lastUpdatedTimes);
            this.tags(model.tags);
            this.statusCodes(model.statusCodes);
        }

        public final Collection<String> getEventArns() {
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        public final Collection<String> getEntityArns() {
            return this.entityArns;
        }

        @Override
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityArns(String ... entityArns) {
            this.entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        public final Collection<String> getEntityValues() {
            return this.entityValues;
        }

        @Override
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityValues(String ... entityValues) {
            this.entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        public final Collection<DateTimeRange.Builder> getLastUpdatedTimes() {
            return this.lastUpdatedTimes != null ? (Collection)this.lastUpdatedTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(DateTimeRange ... lastUpdatedTimes) {
            this.lastUpdatedTimes(Arrays.asList(lastUpdatedTimes));
            return this;
        }

        public final void setLastUpdatedTimes(Collection<DateTimeRange.BuilderImpl> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copyFromBuilder(lastUpdatedTimes);
        }

        public final Collection<Map<String, String>> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Map<String, String> ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
        }

        public final Collection<String> getStatusCodes() {
            return this.statusCodes;
        }

        @Override
        public final Builder statusCodes(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusCodes(String ... statusCodes) {
            this.statusCodes(Arrays.asList(statusCodes));
            return this;
        }

        public final void setStatusCodes(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
        }

        public EntityFilter build() {
            return new EntityFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EntityFilter> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder entityArns(Collection<String> var1);

        public Builder entityArns(String ... var1);

        public Builder entityValues(Collection<String> var1);

        public Builder entityValues(String ... var1);

        public Builder lastUpdatedTimes(Collection<DateTimeRange> var1);

        public Builder lastUpdatedTimes(DateTimeRange ... var1);

        public Builder tags(Collection<Map<String, String>> var1);

        public Builder tags(Map<String, String> ... var1);

        public Builder statusCodes(Collection<String> var1);

        public Builder statusCodes(String ... var1);
    }
}

