/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.transform.EntityAggregateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EntityAggregate
implements StructuredPojo,
ToCopyableBuilder<Builder, EntityAggregate> {
    private final String eventArn;
    private final Integer count;

    private EntityAggregate(BuilderImpl builder) {
        this.eventArn = builder.eventArn;
        this.count = builder.count;
    }

    public String eventArn() {
        return this.eventArn;
    }

    public Integer count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityAggregate)) {
            return false;
        }
        EntityAggregate other = (EntityAggregate)obj;
        return Objects.equals(this.eventArn(), other.eventArn()) && Objects.equals(this.count(), other.count());
    }

    public String toString() {
        return ToString.builder((String)"EntityAggregate").add("EventArn", (Object)this.eventArn()).add("Count", (Object)this.count()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArn": {
                return Optional.of(clazz.cast(this.eventArn()));
            }
            case "count": {
                return Optional.of(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityAggregateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventArn;
        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityAggregate model) {
            this.eventArn(model.eventArn);
            this.count(model.count);
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public EntityAggregate build() {
            return new EntityAggregate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EntityAggregate> {
        public Builder eventArn(String var1);

        public Builder count(Integer var1);
    }
}

