/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.health.model.Event;
import software.amazon.awssdk.services.health.model.EventListCopier;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventsResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeEventsResponse> {
    private final List<Event> events;
    private final String nextToken;

    private DescribeEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.nextToken = builder.nextToken;
    }

    public List<Event> events() {
        return this.events;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResponse)) {
            return false;
        }
        DescribeEventsResponse other = (DescribeEventsResponse)((Object)obj);
        return Objects.equals(this.events(), other.events()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventsResponse").add("Events", this.events()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "events": {
                return Optional.of(clazz.cast(this.events()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<Event> events;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsResponse model) {
            this.events(model.events);
            this.nextToken(model.nextToken);
        }

        public final Collection<Event.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(Event::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<Event.BuilderImpl> events) {
            this.events = EventListCopier.copyFromBuilder(events);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEventsResponse build() {
            return new DescribeEventsResponse(this);
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    CopyableBuilder<Builder, DescribeEventsResponse> {
        public Builder events(Collection<Event> var1);

        public Builder events(Event ... var1);

        public Builder nextToken(String var1);
    }
}

