/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.health.model.EventType;
import software.amazon.awssdk.services.health.model.EventTypeListCopier;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventTypesResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeEventTypesResponse> {
    private final List<EventType> eventTypes;
    private final String nextToken;

    private DescribeEventTypesResponse(BuilderImpl builder) {
        super(builder);
        this.eventTypes = builder.eventTypes;
        this.nextToken = builder.nextToken;
    }

    public List<EventType> eventTypes() {
        return this.eventTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTypesResponse)) {
            return false;
        }
        DescribeEventTypesResponse other = (DescribeEventTypesResponse)((Object)obj);
        return Objects.equals(this.eventTypes(), other.eventTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventTypesResponse").add("EventTypes", this.eventTypes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypes": {
                return Optional.of(clazz.cast(this.eventTypes()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<EventType> eventTypes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTypesResponse model) {
            this.eventTypes(model.eventTypes);
            this.nextToken(model.nextToken);
        }

        public final Collection<EventType.Builder> getEventTypes() {
            return this.eventTypes != null ? (Collection)this.eventTypes.stream().map(EventType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTypes(Collection<EventType> eventTypes) {
            this.eventTypes = EventTypeListCopier.copy(eventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(EventType ... eventTypes) {
            this.eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        public final void setEventTypes(Collection<EventType.BuilderImpl> eventTypes) {
            this.eventTypes = EventTypeListCopier.copyFromBuilder(eventTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEventTypesResponse build() {
            return new DescribeEventTypesResponse(this);
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    CopyableBuilder<Builder, DescribeEventTypesResponse> {
        public Builder eventTypes(Collection<EventType> var1);

        public Builder eventTypes(EventType ... var1);

        public Builder nextToken(String var1);
    }
}

