/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsFailedSetCopier;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsSuccessfulSetCopier;
import software.amazon.awssdk.services.health.model.EventDetails;
import software.amazon.awssdk.services.health.model.EventDetailsErrorItem;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventDetailsResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeEventDetailsResponse> {
    private final List<EventDetails> successfulSet;
    private final List<EventDetailsErrorItem> failedSet;

    private DescribeEventDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulSet = builder.successfulSet;
        this.failedSet = builder.failedSet;
    }

    public List<EventDetails> successfulSet() {
        return this.successfulSet;
    }

    public List<EventDetailsErrorItem> failedSet() {
        return this.failedSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successfulSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsResponse)) {
            return false;
        }
        DescribeEventDetailsResponse other = (DescribeEventDetailsResponse)((Object)obj);
        return Objects.equals(this.successfulSet(), other.successfulSet()) && Objects.equals(this.failedSet(), other.failedSet());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventDetailsResponse").add("SuccessfulSet", this.successfulSet()).add("FailedSet", this.failedSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successfulSet": {
                return Optional.of(clazz.cast(this.successfulSet()));
            }
            case "failedSet": {
                return Optional.of(clazz.cast(this.failedSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<EventDetails> successfulSet;
        private List<EventDetailsErrorItem> failedSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsResponse model) {
            this.successfulSet(model.successfulSet);
            this.failedSet(model.failedSet);
        }

        public final Collection<EventDetails.Builder> getSuccessfulSet() {
            return this.successfulSet != null ? (Collection)this.successfulSet.stream().map(EventDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulSet(Collection<EventDetails> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copy(successfulSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSet(EventDetails ... successfulSet) {
            this.successfulSet(Arrays.asList(successfulSet));
            return this;
        }

        public final void setSuccessfulSet(Collection<EventDetails.BuilderImpl> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copyFromBuilder(successfulSet);
        }

        public final Collection<EventDetailsErrorItem.Builder> getFailedSet() {
            return this.failedSet != null ? (Collection)this.failedSet.stream().map(EventDetailsErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedSet(Collection<EventDetailsErrorItem> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copy(failedSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(EventDetailsErrorItem ... failedSet) {
            this.failedSet(Arrays.asList(failedSet));
            return this;
        }

        public final void setFailedSet(Collection<EventDetailsErrorItem.BuilderImpl> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copyFromBuilder(failedSet);
        }

        @Override
        public DescribeEventDetailsResponse build() {
            return new DescribeEventDetailsResponse(this);
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    CopyableBuilder<Builder, DescribeEventDetailsResponse> {
        public Builder successfulSet(Collection<EventDetails> var1);

        public Builder successfulSet(EventDetails ... var1);

        public Builder failedSet(Collection<EventDetailsErrorItem> var1);

        public Builder failedSet(EventDetailsErrorItem ... var1);
    }
}

