/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.health.model.EventArnsListCopier;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEntityAggregatesRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeEntityAggregatesRequest> {
    private final List<String> eventArns;

    private DescribeEntityAggregatesRequest(BuilderImpl builder) {
        super(builder);
        this.eventArns = builder.eventArns;
    }

    public List<String> eventArns() {
        return this.eventArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityAggregatesRequest)) {
            return false;
        }
        DescribeEntityAggregatesRequest other = (DescribeEntityAggregatesRequest)((Object)obj);
        return Objects.equals(this.eventArns(), other.eventArns());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEntityAggregatesRequest").add("EventArns", this.eventArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.of(clazz.cast(this.eventArns()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private List<String> eventArns;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityAggregatesRequest model) {
            this.eventArns(model.eventArns);
        }

        public final Collection<String> getEventArns() {
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = EventArnsListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = EventArnsListCopier.copy(eventArns);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEntityAggregatesRequest build() {
            return new DescribeEntityAggregatesRequest(this);
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    CopyableBuilder<Builder, DescribeEntityAggregatesRequest> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

