/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.health.model.AffectedEntity;
import software.amazon.awssdk.services.health.model.EntityListCopier;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAffectedEntitiesResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeAffectedEntitiesResponse> {
    private final List<AffectedEntity> entities;
    private final String nextToken;

    private DescribeAffectedEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.nextToken = builder.nextToken;
    }

    public List<AffectedEntity> entities() {
        return this.entities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedEntitiesResponse)) {
            return false;
        }
        DescribeAffectedEntitiesResponse other = (DescribeAffectedEntitiesResponse)((Object)obj);
        return Objects.equals(this.entities(), other.entities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAffectedEntitiesResponse").add("Entities", this.entities()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entities": {
                return Optional.of(clazz.cast(this.entities()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<AffectedEntity> entities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedEntitiesResponse model) {
            this.entities(model.entities);
            this.nextToken(model.nextToken);
        }

        public final Collection<AffectedEntity.Builder> getEntities() {
            return this.entities != null ? (Collection)this.entities.stream().map(AffectedEntity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<AffectedEntity> entities) {
            this.entities = EntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(AffectedEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        public final void setEntities(Collection<AffectedEntity.BuilderImpl> entities) {
            this.entities = EntityListCopier.copyFromBuilder(entities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAffectedEntitiesResponse build() {
            return new DescribeAffectedEntitiesResponse(this);
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    CopyableBuilder<Builder, DescribeAffectedEntitiesResponse> {
        public Builder entities(Collection<AffectedEntity> var1);

        public Builder entities(AffectedEntity ... var1);

        public Builder nextToken(String var1);
    }
}

