/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.EntityStatusCode;
import software.amazon.awssdk.services.health.model._tagSetCopier;
import software.amazon.awssdk.services.health.transform.AffectedEntityMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AffectedEntity
implements StructuredPojo,
ToCopyableBuilder<Builder, AffectedEntity> {
    private final String entityArn;
    private final String eventArn;
    private final String entityValue;
    private final String awsAccountId;
    private final Instant lastUpdatedTime;
    private final String statusCode;
    private final Map<String, String> tags;

    private AffectedEntity(BuilderImpl builder) {
        this.entityArn = builder.entityArn;
        this.eventArn = builder.eventArn;
        this.entityValue = builder.entityValue;
        this.awsAccountId = builder.awsAccountId;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.statusCode = builder.statusCode;
        this.tags = builder.tags;
    }

    public String entityArn() {
        return this.entityArn;
    }

    public String eventArn() {
        return this.eventArn;
    }

    public String entityValue() {
        return this.entityValue;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public EntityStatusCode statusCode() {
        return EntityStatusCode.fromValue(this.statusCode);
    }

    public String statusCodeString() {
        return this.statusCode;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AffectedEntity)) {
            return false;
        }
        AffectedEntity other = (AffectedEntity)obj;
        return Objects.equals(this.entityArn(), other.entityArn()) && Objects.equals(this.eventArn(), other.eventArn()) && Objects.equals(this.entityValue(), other.entityValue()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.statusCodeString(), other.statusCodeString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"AffectedEntity").add("EntityArn", (Object)this.entityArn()).add("EventArn", (Object)this.eventArn()).add("EntityValue", (Object)this.entityValue()).add("AwsAccountId", (Object)this.awsAccountId()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("StatusCode", (Object)this.statusCodeString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityArn": {
                return Optional.of(clazz.cast(this.entityArn()));
            }
            case "eventArn": {
                return Optional.of(clazz.cast(this.eventArn()));
            }
            case "entityValue": {
                return Optional.of(clazz.cast(this.entityValue()));
            }
            case "awsAccountId": {
                return Optional.of(clazz.cast(this.awsAccountId()));
            }
            case "lastUpdatedTime": {
                return Optional.of(clazz.cast(this.lastUpdatedTime()));
            }
            case "statusCode": {
                return Optional.of(clazz.cast(this.statusCodeString()));
            }
            case "tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AffectedEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityArn;
        private String eventArn;
        private String entityValue;
        private String awsAccountId;
        private Instant lastUpdatedTime;
        private String statusCode;
        private Map<String, String> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(AffectedEntity model) {
            this.entityArn(model.entityArn);
            this.eventArn(model.eventArn);
            this.entityValue(model.entityValue);
            this.awsAccountId(model.awsAccountId);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.statusCode(model.statusCode);
            this.tags(model.tags);
        }

        public final String getEntityArn() {
            return this.entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        public final String getEntityValue() {
            return this.entityValue;
        }

        @Override
        public final Builder entityValue(String entityValue) {
            this.entityValue = entityValue;
            return this;
        }

        public final void setEntityValue(String entityValue) {
            this.entityValue = entityValue;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(EntityStatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = _tagSetCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = _tagSetCopier.copy(tags);
        }

        public AffectedEntity build() {
            return new AffectedEntity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AffectedEntity> {
        public Builder entityArn(String var1);

        public Builder eventArn(String var1);

        public Builder entityValue(String var1);

        public Builder awsAccountId(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder statusCode(String var1);

        public Builder statusCode(EntityStatusCode var1);

        public Builder tags(Map<String, String> var1);
    }
}

