/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.transform.EventTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventType
implements StructuredPojo,
ToCopyableBuilder<Builder, EventType> {
    private final String service;
    private final String code;
    private final String category;

    private EventType(BuilderImpl builder) {
        this.service = builder.service;
        this.code = builder.code;
        this.category = builder.category;
    }

    public String service() {
        return this.service;
    }

    public String code() {
        return this.code;
    }

    public EventTypeCategory category() {
        return EventTypeCategory.fromValue(this.category);
    }

    public String categoryString() {
        return this.category;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.service() == null ? 0 : this.service().hashCode());
        hashCode = 31 * hashCode + (this.code() == null ? 0 : this.code().hashCode());
        hashCode = 31 * hashCode + (this.categoryString() == null ? 0 : this.categoryString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventType)) {
            return false;
        }
        EventType other = (EventType)obj;
        if (other.service() == null ^ this.service() == null) {
            return false;
        }
        if (other.service() != null && !other.service().equals(this.service())) {
            return false;
        }
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.categoryString() == null ^ this.categoryString() == null) {
            return false;
        }
        return other.categoryString() == null || other.categoryString().equals(this.categoryString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.service() != null) {
            sb.append("Service: ").append(this.service()).append(",");
        }
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.categoryString() != null) {
            sb.append("Category: ").append(this.categoryString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "service": {
                return Optional.of(clazz.cast(this.service()));
            }
            case "code": {
                return Optional.of(clazz.cast(this.code()));
            }
            case "category": {
                return Optional.of(clazz.cast(this.categoryString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String service;
        private String code;
        private String category;

        private BuilderImpl() {
        }

        private BuilderImpl(EventType model) {
            this.service(model.service);
            this.code(model.code);
            this.category(model.category);
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(EventTypeCategory category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public EventType build() {
            return new EventType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventType> {
        public Builder service(String var1);

        public Builder code(String var1);

        public Builder category(String var1);

        public Builder category(EventTypeCategory var1);
    }
}

