/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.EventStatusCode;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.transform.EventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Event
implements StructuredPojo,
ToCopyableBuilder<Builder, Event> {
    private final String arn;
    private final String service;
    private final String eventTypeCode;
    private final String eventTypeCategory;
    private final String region;
    private final String availabilityZone;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant lastUpdatedTime;
    private final String statusCode;

    private Event(BuilderImpl builder) {
        this.arn = builder.arn;
        this.service = builder.service;
        this.eventTypeCode = builder.eventTypeCode;
        this.eventTypeCategory = builder.eventTypeCategory;
        this.region = builder.region;
        this.availabilityZone = builder.availabilityZone;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.statusCode = builder.statusCode;
    }

    public String arn() {
        return this.arn;
    }

    public String service() {
        return this.service;
    }

    public String eventTypeCode() {
        return this.eventTypeCode;
    }

    public EventTypeCategory eventTypeCategory() {
        return EventTypeCategory.fromValue(this.eventTypeCategory);
    }

    public String eventTypeCategoryString() {
        return this.eventTypeCategory;
    }

    public String region() {
        return this.region;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public EventStatusCode statusCode() {
        return EventStatusCode.fromValue(this.statusCode);
    }

    public String statusCodeString() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.service() == null ? 0 : this.service().hashCode());
        hashCode = 31 * hashCode + (this.eventTypeCode() == null ? 0 : this.eventTypeCode().hashCode());
        hashCode = 31 * hashCode + (this.eventTypeCategoryString() == null ? 0 : this.eventTypeCategoryString().hashCode());
        hashCode = 31 * hashCode + (this.region() == null ? 0 : this.region().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedTime() == null ? 0 : this.lastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.statusCodeString() == null ? 0 : this.statusCodeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.service() == null ^ this.service() == null) {
            return false;
        }
        if (other.service() != null && !other.service().equals(this.service())) {
            return false;
        }
        if (other.eventTypeCode() == null ^ this.eventTypeCode() == null) {
            return false;
        }
        if (other.eventTypeCode() != null && !other.eventTypeCode().equals(this.eventTypeCode())) {
            return false;
        }
        if (other.eventTypeCategoryString() == null ^ this.eventTypeCategoryString() == null) {
            return false;
        }
        if (other.eventTypeCategoryString() != null && !other.eventTypeCategoryString().equals(this.eventTypeCategoryString())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.lastUpdatedTime() == null ^ this.lastUpdatedTime() == null) {
            return false;
        }
        if (other.lastUpdatedTime() != null && !other.lastUpdatedTime().equals(this.lastUpdatedTime())) {
            return false;
        }
        if (other.statusCodeString() == null ^ this.statusCodeString() == null) {
            return false;
        }
        return other.statusCodeString() == null || other.statusCodeString().equals(this.statusCodeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.service() != null) {
            sb.append("Service: ").append(this.service()).append(",");
        }
        if (this.eventTypeCode() != null) {
            sb.append("EventTypeCode: ").append(this.eventTypeCode()).append(",");
        }
        if (this.eventTypeCategoryString() != null) {
            sb.append("EventTypeCategory: ").append(this.eventTypeCategoryString()).append(",");
        }
        if (this.region() != null) {
            sb.append("Region: ").append(this.region()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.lastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.lastUpdatedTime()).append(",");
        }
        if (this.statusCodeString() != null) {
            sb.append("StatusCode: ").append(this.statusCodeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "service": {
                return Optional.of(clazz.cast(this.service()));
            }
            case "eventTypeCode": {
                return Optional.of(clazz.cast(this.eventTypeCode()));
            }
            case "eventTypeCategory": {
                return Optional.of(clazz.cast(this.eventTypeCategoryString()));
            }
            case "region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "availabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "startTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "lastUpdatedTime": {
                return Optional.of(clazz.cast(this.lastUpdatedTime()));
            }
            case "statusCode": {
                return Optional.of(clazz.cast(this.statusCodeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String service;
        private String eventTypeCode;
        private String eventTypeCategory;
        private String region;
        private String availabilityZone;
        private Instant startTime;
        private Instant endTime;
        private Instant lastUpdatedTime;
        private String statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.arn(model.arn);
            this.service(model.service);
            this.eventTypeCode(model.eventTypeCode);
            this.eventTypeCategory(model.eventTypeCategory);
            this.region(model.region);
            this.availabilityZone(model.availabilityZone);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.statusCode(model.statusCode);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getEventTypeCode() {
            return this.eventTypeCode;
        }

        @Override
        public final Builder eventTypeCode(String eventTypeCode) {
            this.eventTypeCode = eventTypeCode;
            return this;
        }

        public final void setEventTypeCode(String eventTypeCode) {
            this.eventTypeCode = eventTypeCode;
        }

        public final String getEventTypeCategory() {
            return this.eventTypeCategory;
        }

        @Override
        public final Builder eventTypeCategory(String eventTypeCategory) {
            this.eventTypeCategory = eventTypeCategory;
            return this;
        }

        @Override
        public final Builder eventTypeCategory(EventTypeCategory eventTypeCategory) {
            this.eventTypeCategory(eventTypeCategory.toString());
            return this;
        }

        public final void setEventTypeCategory(String eventTypeCategory) {
            this.eventTypeCategory = eventTypeCategory;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(EventStatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public Event build() {
            return new Event(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Event> {
        public Builder arn(String var1);

        public Builder service(String var1);

        public Builder eventTypeCode(String var1);

        public Builder eventTypeCategory(String var1);

        public Builder eventTypeCategory(EventTypeCategory var1);

        public Builder region(String var1);

        public Builder availabilityZone(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder statusCode(String var1);

        public Builder statusCode(EventStatusCode var1);
    }
}

