/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsFailedSetCopier;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsSuccessfulSetCopier;
import software.amazon.awssdk.services.health.model.EventDetails;
import software.amazon.awssdk.services.health.model.EventDetailsErrorItem;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventDetailsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventDetailsResponse> {
    private final List<EventDetails> successfulSet;
    private final List<EventDetailsErrorItem> failedSet;

    private DescribeEventDetailsResponse(BuilderImpl builder) {
        this.successfulSet = builder.successfulSet;
        this.failedSet = builder.failedSet;
    }

    public List<EventDetails> successfulSet() {
        return this.successfulSet;
    }

    public List<EventDetailsErrorItem> failedSet() {
        return this.failedSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.successfulSet() == null ? 0 : this.successfulSet().hashCode());
        hashCode = 31 * hashCode + (this.failedSet() == null ? 0 : this.failedSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsResponse)) {
            return false;
        }
        DescribeEventDetailsResponse other = (DescribeEventDetailsResponse)((Object)obj);
        if (other.successfulSet() == null ^ this.successfulSet() == null) {
            return false;
        }
        if (other.successfulSet() != null && !other.successfulSet().equals(this.successfulSet())) {
            return false;
        }
        if (other.failedSet() == null ^ this.failedSet() == null) {
            return false;
        }
        return other.failedSet() == null || other.failedSet().equals(this.failedSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.successfulSet() != null) {
            sb.append("SuccessfulSet: ").append(this.successfulSet()).append(",");
        }
        if (this.failedSet() != null) {
            sb.append("FailedSet: ").append(this.failedSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successfulSet": {
                return Optional.of(clazz.cast(this.successfulSet()));
            }
            case "failedSet": {
                return Optional.of(clazz.cast(this.failedSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<EventDetails> successfulSet;
        private List<EventDetailsErrorItem> failedSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsResponse model) {
            this.successfulSet(model.successfulSet);
            this.failedSet(model.failedSet);
        }

        public final Collection<EventDetails.Builder> getSuccessfulSet() {
            return this.successfulSet != null ? (Collection)this.successfulSet.stream().map(EventDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulSet(Collection<EventDetails> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copy(successfulSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSet(EventDetails ... successfulSet) {
            this.successfulSet(Arrays.asList(successfulSet));
            return this;
        }

        public final void setSuccessfulSet(Collection<EventDetails.BuilderImpl> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copyFromBuilder(successfulSet);
        }

        public final Collection<EventDetailsErrorItem.Builder> getFailedSet() {
            return this.failedSet != null ? (Collection)this.failedSet.stream().map(EventDetailsErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedSet(Collection<EventDetailsErrorItem> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copy(failedSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(EventDetailsErrorItem ... failedSet) {
            this.failedSet(Arrays.asList(failedSet));
            return this;
        }

        public final void setFailedSet(Collection<EventDetailsErrorItem.BuilderImpl> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copyFromBuilder(failedSet);
        }

        public DescribeEventDetailsResponse build() {
            return new DescribeEventDetailsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventDetailsResponse> {
        public Builder successfulSet(Collection<EventDetails> var1);

        public Builder successfulSet(EventDetails ... var1);

        public Builder failedSet(Collection<EventDetailsErrorItem> var1);

        public Builder failedSet(EventDetailsErrorItem ... var1);
    }
}

