/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.health.model._eventArnListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventDetailsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeEventDetailsRequest> {
    private final List<String> eventArns;
    private final String locale;

    private DescribeEventDetailsRequest(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.locale = builder.locale;
    }

    public List<String> eventArns() {
        return this.eventArns;
    }

    public String locale() {
        return this.locale;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventArns() == null ? 0 : this.eventArns().hashCode());
        hashCode = 31 * hashCode + (this.locale() == null ? 0 : this.locale().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsRequest)) {
            return false;
        }
        DescribeEventDetailsRequest other = (DescribeEventDetailsRequest)((Object)obj);
        if (other.eventArns() == null ^ this.eventArns() == null) {
            return false;
        }
        if (other.eventArns() != null && !other.eventArns().equals(this.eventArns())) {
            return false;
        }
        if (other.locale() == null ^ this.locale() == null) {
            return false;
        }
        return other.locale() == null || other.locale().equals(this.locale());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.eventArns() != null) {
            sb.append("EventArns: ").append(this.eventArns()).append(",");
        }
        if (this.locale() != null) {
            sb.append("Locale: ").append(this.locale()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.of(clazz.cast(this.eventArns()));
            }
            case "locale": {
                return Optional.of(clazz.cast(this.locale()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventArns;
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsRequest model) {
            this.eventArns(model.eventArns);
            this.locale(model.locale);
        }

        public final Collection<String> getEventArns() {
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public DescribeEventDetailsRequest build() {
            return new DescribeEventDetailsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventDetailsRequest> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder locale(String var1);
    }
}

