/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.health.model.EventAggregate;
import software.amazon.awssdk.services.health.model.EventAggregateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventAggregatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventAggregatesResponse> {
    private final List<EventAggregate> eventAggregates;
    private final String nextToken;

    private DescribeEventAggregatesResponse(BuilderImpl builder) {
        this.eventAggregates = builder.eventAggregates;
        this.nextToken = builder.nextToken;
    }

    public List<EventAggregate> eventAggregates() {
        return this.eventAggregates;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventAggregates() == null ? 0 : this.eventAggregates().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventAggregatesResponse)) {
            return false;
        }
        DescribeEventAggregatesResponse other = (DescribeEventAggregatesResponse)((Object)obj);
        if (other.eventAggregates() == null ^ this.eventAggregates() == null) {
            return false;
        }
        if (other.eventAggregates() != null && !other.eventAggregates().equals(this.eventAggregates())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.eventAggregates() != null) {
            sb.append("EventAggregates: ").append(this.eventAggregates()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventAggregates": {
                return Optional.of(clazz.cast(this.eventAggregates()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<EventAggregate> eventAggregates;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventAggregatesResponse model) {
            this.eventAggregates(model.eventAggregates);
            this.nextToken(model.nextToken);
        }

        public final Collection<EventAggregate.Builder> getEventAggregates() {
            return this.eventAggregates != null ? (Collection)this.eventAggregates.stream().map(EventAggregate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventAggregates(Collection<EventAggregate> eventAggregates) {
            this.eventAggregates = EventAggregateListCopier.copy(eventAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventAggregates(EventAggregate ... eventAggregates) {
            this.eventAggregates(Arrays.asList(eventAggregates));
            return this;
        }

        public final void setEventAggregates(Collection<EventAggregate.BuilderImpl> eventAggregates) {
            this.eventAggregates = EventAggregateListCopier.copyFromBuilder(eventAggregates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEventAggregatesResponse build() {
            return new DescribeEventAggregatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventAggregatesResponse> {
        public Builder eventAggregates(Collection<EventAggregate> var1);

        public Builder eventAggregates(EventAggregate ... var1);

        public Builder nextToken(String var1);
    }
}

