/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.health.model.EventAggregateField;
import software.amazon.awssdk.services.health.model.EventFilter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventAggregatesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeEventAggregatesRequest> {
    private final EventFilter filter;
    private final String aggregateField;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeEventAggregatesRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.aggregateField = builder.aggregateField;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public EventFilter filter() {
        return this.filter;
    }

    public EventAggregateField aggregateField() {
        return EventAggregateField.fromValue(this.aggregateField);
    }

    public String aggregateFieldString() {
        return this.aggregateField;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        hashCode = 31 * hashCode + (this.aggregateFieldString() == null ? 0 : this.aggregateFieldString().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventAggregatesRequest)) {
            return false;
        }
        DescribeEventAggregatesRequest other = (DescribeEventAggregatesRequest)((Object)obj);
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.aggregateFieldString() == null ^ this.aggregateFieldString() == null) {
            return false;
        }
        if (other.aggregateFieldString() != null && !other.aggregateFieldString().equals(this.aggregateFieldString())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.aggregateFieldString() != null) {
            sb.append("AggregateField: ").append(this.aggregateFieldString()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
            case "aggregateField": {
                return Optional.of(clazz.cast(this.aggregateFieldString()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private EventFilter filter;
        private String aggregateField;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventAggregatesRequest model) {
            this.filter(model.filter);
            this.aggregateField(model.aggregateField);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final EventFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(EventFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(EventFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getAggregateField() {
            return this.aggregateField;
        }

        @Override
        public final Builder aggregateField(String aggregateField) {
            this.aggregateField = aggregateField;
            return this;
        }

        @Override
        public final Builder aggregateField(EventAggregateField aggregateField) {
            this.aggregateField(aggregateField.toString());
            return this;
        }

        public final void setAggregateField(String aggregateField) {
            this.aggregateField = aggregateField;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEventAggregatesRequest build() {
            return new DescribeEventAggregatesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventAggregatesRequest> {
        public Builder filter(EventFilter var1);

        public Builder aggregateField(String var1);

        public Builder aggregateField(EventAggregateField var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

