/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.health.model.EntityAggregate;
import software.amazon.awssdk.services.health.model.EntityAggregateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEntityAggregatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEntityAggregatesResponse> {
    private final List<EntityAggregate> entityAggregates;

    private DescribeEntityAggregatesResponse(BuilderImpl builder) {
        this.entityAggregates = builder.entityAggregates;
    }

    public List<EntityAggregate> entityAggregates() {
        return this.entityAggregates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.entityAggregates() == null ? 0 : this.entityAggregates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityAggregatesResponse)) {
            return false;
        }
        DescribeEntityAggregatesResponse other = (DescribeEntityAggregatesResponse)((Object)obj);
        if (other.entityAggregates() == null ^ this.entityAggregates() == null) {
            return false;
        }
        return other.entityAggregates() == null || other.entityAggregates().equals(this.entityAggregates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.entityAggregates() != null) {
            sb.append("EntityAggregates: ").append(this.entityAggregates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityAggregates": {
                return Optional.of(clazz.cast(this.entityAggregates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<EntityAggregate> entityAggregates;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityAggregatesResponse model) {
            this.entityAggregates(model.entityAggregates);
        }

        public final Collection<EntityAggregate.Builder> getEntityAggregates() {
            return this.entityAggregates != null ? (Collection)this.entityAggregates.stream().map(EntityAggregate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entityAggregates(Collection<EntityAggregate> entityAggregates) {
            this.entityAggregates = EntityAggregateListCopier.copy(entityAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityAggregates(EntityAggregate ... entityAggregates) {
            this.entityAggregates(Arrays.asList(entityAggregates));
            return this;
        }

        public final void setEntityAggregates(Collection<EntityAggregate.BuilderImpl> entityAggregates) {
            this.entityAggregates = EntityAggregateListCopier.copyFromBuilder(entityAggregates);
        }

        public DescribeEntityAggregatesResponse build() {
            return new DescribeEntityAggregatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEntityAggregatesResponse> {
        public Builder entityAggregates(Collection<EntityAggregate> var1);

        public Builder entityAggregates(EntityAggregate ... var1);
    }
}

