/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.transform.DateTimeRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DateTimeRange
implements StructuredPojo,
ToCopyableBuilder<Builder, DateTimeRange> {
    private final Instant from;
    private final Instant to;

    private DateTimeRange(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
    }

    public Instant from() {
        return this.from;
    }

    public Instant to() {
        return this.to;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.from() == null ? 0 : this.from().hashCode());
        hashCode = 31 * hashCode + (this.to() == null ? 0 : this.to().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRange)) {
            return false;
        }
        DateTimeRange other = (DateTimeRange)obj;
        if (other.from() == null ^ this.from() == null) {
            return false;
        }
        if (other.from() != null && !other.from().equals(this.from())) {
            return false;
        }
        if (other.to() == null ^ this.to() == null) {
            return false;
        }
        return other.to() == null || other.to().equals(this.to());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.from() != null) {
            sb.append("From: ").append(this.from()).append(",");
        }
        if (this.to() != null) {
            sb.append("To: ").append(this.to()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "from": {
                return Optional.of(clazz.cast(this.from()));
            }
            case "to": {
                return Optional.of(clazz.cast(this.to()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DateTimeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant from;
        private Instant to;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeRange model) {
            this.from(model.from);
            this.to(model.to);
        }

        public final Instant getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(Instant from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Instant from) {
            this.from = from;
        }

        public final Instant getTo() {
            return this.to;
        }

        @Override
        public final Builder to(Instant to) {
            this.to = to;
            return this;
        }

        public final void setTo(Instant to) {
            this.to = to;
        }

        public DateTimeRange build() {
            return new DateTimeRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DateTimeRange> {
        public Builder from(Instant var1);

        public Builder to(Instant var1);
    }
}

