/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.Event;

@SdkInternalApi
public class EventMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> SERVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("service").build();
    private static final MarshallingInfo<String> EVENTTYPECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCode").build();
    private static final MarshallingInfo<String> EVENTTYPECATEGORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCategory").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").build();
    private static final MarshallingInfo<Instant> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").build();
    private static final EventMarshaller INSTANCE = new EventMarshaller();

    public static EventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Event event, ProtocolMarshaller protocolMarshaller) {
        if (event == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)event.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)event.service(), SERVICE_BINDING);
            protocolMarshaller.marshall((Object)event.eventTypeCode(), EVENTTYPECODE_BINDING);
            protocolMarshaller.marshall((Object)event.eventTypeCategory(), EVENTTYPECATEGORY_BINDING);
            protocolMarshaller.marshall((Object)event.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)event.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)event.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)event.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)event.lastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)event.statusCode(), STATUSCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

