/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.health.model.EventFilter;
import software.amazon.awssdk.services.health.transform.DateTimeRangeUnmarshaller;

public class EventFilterUnmarshaller
implements Unmarshaller<EventFilter, JsonUnmarshallerContext> {
    private static final EventFilterUnmarshaller INSTANCE = new EventFilterUnmarshaller();

    public EventFilter unmarshall(JsonUnmarshallerContext context) throws Exception {
        EventFilter.Builder eventFilterBuilder = EventFilter.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("eventArns", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.eventArns(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("eventTypeCodes", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.eventTypeCodes(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("services", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.services(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("regions", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.regions(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("availabilityZones", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.availabilityZones(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("startTimes", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.startTimes(new ListUnmarshaller((Unmarshaller)DateTimeRangeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("endTimes", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.endTimes(new ListUnmarshaller((Unmarshaller)DateTimeRangeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("lastUpdatedTimes", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.lastUpdatedTimes(new ListUnmarshaller((Unmarshaller)DateTimeRangeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("entityArns", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.entityArns(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("entityValues", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.entityValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("eventTypeCategories", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.eventTypeCategories(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.tags(new ListUnmarshaller((Unmarshaller)new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("eventStatusCodes", targetDepth)) {
                    context.nextToken();
                    eventFilterBuilder.eventStatusCodes(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EventFilter)eventFilterBuilder.build();
    }

    public static EventFilterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

