/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.EventFilter;

@SdkInternalApi
public class EventFilterMarshaller {
    private static final MarshallingInfo<List> EVENTARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventArns").build();
    private static final MarshallingInfo<List> EVENTTYPECODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCodes").build();
    private static final MarshallingInfo<List> SERVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("services").build();
    private static final MarshallingInfo<List> REGIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regions").build();
    private static final MarshallingInfo<List> AVAILABILITYZONES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZones").build();
    private static final MarshallingInfo<List> STARTTIMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTimes").build();
    private static final MarshallingInfo<List> ENDTIMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTimes").build();
    private static final MarshallingInfo<List> LASTUPDATEDTIMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTimes").build();
    private static final MarshallingInfo<List> ENTITYARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityArns").build();
    private static final MarshallingInfo<List> ENTITYVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityValues").build();
    private static final MarshallingInfo<List> EVENTTYPECATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCategories").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<List> EVENTSTATUSCODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventStatusCodes").build();
    private static final EventFilterMarshaller INSTANCE = new EventFilterMarshaller();

    public static EventFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventFilter eventFilter, ProtocolMarshaller protocolMarshaller) {
        if (eventFilter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(eventFilter.eventArns(), EVENTARNS_BINDING);
            protocolMarshaller.marshall(eventFilter.eventTypeCodes(), EVENTTYPECODES_BINDING);
            protocolMarshaller.marshall(eventFilter.services(), SERVICES_BINDING);
            protocolMarshaller.marshall(eventFilter.regions(), REGIONS_BINDING);
            protocolMarshaller.marshall(eventFilter.availabilityZones(), AVAILABILITYZONES_BINDING);
            protocolMarshaller.marshall(eventFilter.startTimes(), STARTTIMES_BINDING);
            protocolMarshaller.marshall(eventFilter.endTimes(), ENDTIMES_BINDING);
            protocolMarshaller.marshall(eventFilter.lastUpdatedTimes(), LASTUPDATEDTIMES_BINDING);
            protocolMarshaller.marshall(eventFilter.entityArns(), ENTITYARNS_BINDING);
            protocolMarshaller.marshall(eventFilter.entityValues(), ENTITYVALUES_BINDING);
            protocolMarshaller.marshall(eventFilter.eventTypeCategories(), EVENTTYPECATEGORIES_BINDING);
            protocolMarshaller.marshall(eventFilter.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(eventFilter.eventStatusCodes(), EVENTSTATUSCODES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

