/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.health.model.EntityFilter;
import software.amazon.awssdk.services.health.transform.DateTimeRangeUnmarshaller;

public class EntityFilterUnmarshaller
implements Unmarshaller<EntityFilter, JsonUnmarshallerContext> {
    private static final EntityFilterUnmarshaller INSTANCE = new EntityFilterUnmarshaller();

    public EntityFilter unmarshall(JsonUnmarshallerContext context) throws Exception {
        EntityFilter.Builder entityFilterBuilder = EntityFilter.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("eventArns", targetDepth)) {
                    context.nextToken();
                    entityFilterBuilder.eventArns(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("entityArns", targetDepth)) {
                    context.nextToken();
                    entityFilterBuilder.entityArns(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("entityValues", targetDepth)) {
                    context.nextToken();
                    entityFilterBuilder.entityValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("lastUpdatedTimes", targetDepth)) {
                    context.nextToken();
                    entityFilterBuilder.lastUpdatedTimes(new ListUnmarshaller((Unmarshaller)DateTimeRangeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    context.nextToken();
                    entityFilterBuilder.tags(new ListUnmarshaller((Unmarshaller)new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("statusCodes", targetDepth)) {
                    context.nextToken();
                    entityFilterBuilder.statusCodes(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EntityFilter)entityFilterBuilder.build();
    }

    public static EntityFilterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

