/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.DateTimeRange;

@SdkInternalApi
public class DateTimeRangeMarshaller {
    private static final MarshallingInfo<Instant> FROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("from").build();
    private static final MarshallingInfo<Instant> TO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("to").build();
    private static final DateTimeRangeMarshaller INSTANCE = new DateTimeRangeMarshaller();

    public static DateTimeRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DateTimeRange dateTimeRange, ProtocolMarshaller protocolMarshaller) {
        if (dateTimeRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dateTimeRange.from(), FROM_BINDING);
            protocolMarshaller.marshall((Object)dateTimeRange.to(), TO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

