/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.model.EventTypeCategoryListCopier;
import software.amazon.awssdk.services.health.model.EventTypeCodeListCopier;
import software.amazon.awssdk.services.health.model._serviceListCopier;
import software.amazon.awssdk.services.health.transform.EventTypeFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventTypeFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, EventTypeFilter> {
    private final List<String> eventTypeCodes;
    private final List<String> services;
    private final List<String> eventTypeCategories;

    private EventTypeFilter(BuilderImpl builder) {
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.eventTypeCategories = builder.eventTypeCategories;
    }

    public List<String> eventTypeCodes() {
        return this.eventTypeCodes;
    }

    public List<String> services() {
        return this.services;
    }

    public List<String> eventTypeCategories() {
        return this.eventTypeCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventTypeCodes() == null ? 0 : this.eventTypeCodes().hashCode());
        hashCode = 31 * hashCode + (this.services() == null ? 0 : this.services().hashCode());
        hashCode = 31 * hashCode + (this.eventTypeCategories() == null ? 0 : this.eventTypeCategories().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTypeFilter)) {
            return false;
        }
        EventTypeFilter other = (EventTypeFilter)obj;
        if (other.eventTypeCodes() == null ^ this.eventTypeCodes() == null) {
            return false;
        }
        if (other.eventTypeCodes() != null && !other.eventTypeCodes().equals(this.eventTypeCodes())) {
            return false;
        }
        if (other.services() == null ^ this.services() == null) {
            return false;
        }
        if (other.services() != null && !other.services().equals(this.services())) {
            return false;
        }
        if (other.eventTypeCategories() == null ^ this.eventTypeCategories() == null) {
            return false;
        }
        return other.eventTypeCategories() == null || other.eventTypeCategories().equals(this.eventTypeCategories());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventTypeCodes() != null) {
            sb.append("EventTypeCodes: ").append(this.eventTypeCodes()).append(",");
        }
        if (this.services() != null) {
            sb.append("Services: ").append(this.services()).append(",");
        }
        if (this.eventTypeCategories() != null) {
            sb.append("EventTypeCategories: ").append(this.eventTypeCategories()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventTypeFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> eventTypeCodes;
        private List<String> services;
        private List<String> eventTypeCategories;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTypeFilter model) {
            this.setEventTypeCodes(model.eventTypeCodes);
            this.setServices(model.services);
            this.setEventTypeCategories(model.eventTypeCategories);
        }

        public final Collection<String> getEventTypeCodes() {
            return this.eventTypeCodes;
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String ... eventTypeCodes) {
            this.eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
        }

        public final Collection<String> getServices() {
            return this.services;
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        public final Collection<String> getEventTypeCategories() {
            return this.eventTypeCategories;
        }

        @Override
        public final Builder eventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(String ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        public EventTypeFilter build() {
            return new EventTypeFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventTypeFilter> {
        public Builder eventTypeCodes(Collection<String> var1);

        public Builder eventTypeCodes(String ... var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);

        public Builder eventTypeCategories(Collection<String> var1);

        public Builder eventTypeCategories(String ... var1);

        public Builder eventTypeCategories(EventTypeCategory ... var1);
    }
}

