/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.transform.EventTypeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventType
implements StructuredPojo,
ToCopyableBuilder<Builder, EventType> {
    private final String service;
    private final String code;
    private final String category;

    private EventType(BuilderImpl builder) {
        this.service = builder.service;
        this.code = builder.code;
        this.category = builder.category;
    }

    public String service() {
        return this.service;
    }

    public String code() {
        return this.code;
    }

    public String category() {
        return this.category;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.service() == null ? 0 : this.service().hashCode());
        hashCode = 31 * hashCode + (this.code() == null ? 0 : this.code().hashCode());
        hashCode = 31 * hashCode + (this.category() == null ? 0 : this.category().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventType)) {
            return false;
        }
        EventType other = (EventType)obj;
        if (other.service() == null ^ this.service() == null) {
            return false;
        }
        if (other.service() != null && !other.service().equals(this.service())) {
            return false;
        }
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.category() == null ^ this.category() == null) {
            return false;
        }
        return other.category() == null || other.category().equals(this.category());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.service() != null) {
            sb.append("Service: ").append(this.service()).append(",");
        }
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.category() != null) {
            sb.append("Category: ").append(this.category()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String service;
        private String code;
        private String category;

        private BuilderImpl() {
        }

        private BuilderImpl(EventType model) {
            this.setService(model.service);
            this.setCode(model.code);
            this.setCategory(model.category);
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(EventTypeCategory category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public EventType build() {
            return new EventType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventType> {
        public Builder service(String var1);

        public Builder code(String var1);

        public Builder category(String var1);

        public Builder category(EventTypeCategory var1);
    }
}

