/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.DateTimeRange;
import software.amazon.awssdk.services.health.model.EventStatusCode;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.model._availabilityZonesCopier;
import software.amazon.awssdk.services.health.model._dateTimeRangeListCopier;
import software.amazon.awssdk.services.health.model._entityArnListCopier;
import software.amazon.awssdk.services.health.model._entityValueListCopier;
import software.amazon.awssdk.services.health.model._eventArnListCopier;
import software.amazon.awssdk.services.health.model._eventStatusCodeListCopier;
import software.amazon.awssdk.services.health.model._eventTypeCategoryListCopier;
import software.amazon.awssdk.services.health.model._eventTypeListCopier;
import software.amazon.awssdk.services.health.model._regionListCopier;
import software.amazon.awssdk.services.health.model._serviceListCopier;
import software.amazon.awssdk.services.health.model._tagFilterCopier;
import software.amazon.awssdk.services.health.transform.EventFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, EventFilter> {
    private final List<String> eventArns;
    private final List<String> eventTypeCodes;
    private final List<String> services;
    private final List<String> regions;
    private final List<String> availabilityZones;
    private final List<DateTimeRange> startTimes;
    private final List<DateTimeRange> endTimes;
    private final List<DateTimeRange> lastUpdatedTimes;
    private final List<String> entityArns;
    private final List<String> entityValues;
    private final List<String> eventTypeCategories;
    private final List<Map<String, String>> tags;
    private final List<String> eventStatusCodes;

    private EventFilter(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.regions = builder.regions;
        this.availabilityZones = builder.availabilityZones;
        this.startTimes = builder.startTimes;
        this.endTimes = builder.endTimes;
        this.lastUpdatedTimes = builder.lastUpdatedTimes;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.eventTypeCategories = builder.eventTypeCategories;
        this.tags = builder.tags;
        this.eventStatusCodes = builder.eventStatusCodes;
    }

    public List<String> eventArns() {
        return this.eventArns;
    }

    public List<String> eventTypeCodes() {
        return this.eventTypeCodes;
    }

    public List<String> services() {
        return this.services;
    }

    public List<String> regions() {
        return this.regions;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<DateTimeRange> startTimes() {
        return this.startTimes;
    }

    public List<DateTimeRange> endTimes() {
        return this.endTimes;
    }

    public List<DateTimeRange> lastUpdatedTimes() {
        return this.lastUpdatedTimes;
    }

    public List<String> entityArns() {
        return this.entityArns;
    }

    public List<String> entityValues() {
        return this.entityValues;
    }

    public List<String> eventTypeCategories() {
        return this.eventTypeCategories;
    }

    public List<Map<String, String>> tags() {
        return this.tags;
    }

    public List<String> eventStatusCodes() {
        return this.eventStatusCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventArns() == null ? 0 : this.eventArns().hashCode());
        hashCode = 31 * hashCode + (this.eventTypeCodes() == null ? 0 : this.eventTypeCodes().hashCode());
        hashCode = 31 * hashCode + (this.services() == null ? 0 : this.services().hashCode());
        hashCode = 31 * hashCode + (this.regions() == null ? 0 : this.regions().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.startTimes() == null ? 0 : this.startTimes().hashCode());
        hashCode = 31 * hashCode + (this.endTimes() == null ? 0 : this.endTimes().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedTimes() == null ? 0 : this.lastUpdatedTimes().hashCode());
        hashCode = 31 * hashCode + (this.entityArns() == null ? 0 : this.entityArns().hashCode());
        hashCode = 31 * hashCode + (this.entityValues() == null ? 0 : this.entityValues().hashCode());
        hashCode = 31 * hashCode + (this.eventTypeCategories() == null ? 0 : this.eventTypeCategories().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.eventStatusCodes() == null ? 0 : this.eventStatusCodes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter)obj;
        if (other.eventArns() == null ^ this.eventArns() == null) {
            return false;
        }
        if (other.eventArns() != null && !other.eventArns().equals(this.eventArns())) {
            return false;
        }
        if (other.eventTypeCodes() == null ^ this.eventTypeCodes() == null) {
            return false;
        }
        if (other.eventTypeCodes() != null && !other.eventTypeCodes().equals(this.eventTypeCodes())) {
            return false;
        }
        if (other.services() == null ^ this.services() == null) {
            return false;
        }
        if (other.services() != null && !other.services().equals(this.services())) {
            return false;
        }
        if (other.regions() == null ^ this.regions() == null) {
            return false;
        }
        if (other.regions() != null && !other.regions().equals(this.regions())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.startTimes() == null ^ this.startTimes() == null) {
            return false;
        }
        if (other.startTimes() != null && !other.startTimes().equals(this.startTimes())) {
            return false;
        }
        if (other.endTimes() == null ^ this.endTimes() == null) {
            return false;
        }
        if (other.endTimes() != null && !other.endTimes().equals(this.endTimes())) {
            return false;
        }
        if (other.lastUpdatedTimes() == null ^ this.lastUpdatedTimes() == null) {
            return false;
        }
        if (other.lastUpdatedTimes() != null && !other.lastUpdatedTimes().equals(this.lastUpdatedTimes())) {
            return false;
        }
        if (other.entityArns() == null ^ this.entityArns() == null) {
            return false;
        }
        if (other.entityArns() != null && !other.entityArns().equals(this.entityArns())) {
            return false;
        }
        if (other.entityValues() == null ^ this.entityValues() == null) {
            return false;
        }
        if (other.entityValues() != null && !other.entityValues().equals(this.entityValues())) {
            return false;
        }
        if (other.eventTypeCategories() == null ^ this.eventTypeCategories() == null) {
            return false;
        }
        if (other.eventTypeCategories() != null && !other.eventTypeCategories().equals(this.eventTypeCategories())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.eventStatusCodes() == null ^ this.eventStatusCodes() == null) {
            return false;
        }
        return other.eventStatusCodes() == null || other.eventStatusCodes().equals(this.eventStatusCodes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventArns() != null) {
            sb.append("EventArns: ").append(this.eventArns()).append(",");
        }
        if (this.eventTypeCodes() != null) {
            sb.append("EventTypeCodes: ").append(this.eventTypeCodes()).append(",");
        }
        if (this.services() != null) {
            sb.append("Services: ").append(this.services()).append(",");
        }
        if (this.regions() != null) {
            sb.append("Regions: ").append(this.regions()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.startTimes() != null) {
            sb.append("StartTimes: ").append(this.startTimes()).append(",");
        }
        if (this.endTimes() != null) {
            sb.append("EndTimes: ").append(this.endTimes()).append(",");
        }
        if (this.lastUpdatedTimes() != null) {
            sb.append("LastUpdatedTimes: ").append(this.lastUpdatedTimes()).append(",");
        }
        if (this.entityArns() != null) {
            sb.append("EntityArns: ").append(this.entityArns()).append(",");
        }
        if (this.entityValues() != null) {
            sb.append("EntityValues: ").append(this.entityValues()).append(",");
        }
        if (this.eventTypeCategories() != null) {
            sb.append("EventTypeCategories: ").append(this.eventTypeCategories()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.eventStatusCodes() != null) {
            sb.append("EventStatusCodes: ").append(this.eventStatusCodes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> eventArns;
        private List<String> eventTypeCodes;
        private List<String> services;
        private List<String> regions;
        private List<String> availabilityZones;
        private List<DateTimeRange> startTimes;
        private List<DateTimeRange> endTimes;
        private List<DateTimeRange> lastUpdatedTimes;
        private List<String> entityArns;
        private List<String> entityValues;
        private List<String> eventTypeCategories;
        private List<Map<String, String>> tags;
        private List<String> eventStatusCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(EventFilter model) {
            this.setEventArns(model.eventArns);
            this.setEventTypeCodes(model.eventTypeCodes);
            this.setServices(model.services);
            this.setRegions(model.regions);
            this.setAvailabilityZones(model.availabilityZones);
            this.setStartTimes(model.startTimes);
            this.setEndTimes(model.endTimes);
            this.setLastUpdatedTimes(model.lastUpdatedTimes);
            this.setEntityArns(model.entityArns);
            this.setEntityValues(model.entityValues);
            this.setEventTypeCategories(model.eventTypeCategories);
            this.setTags(model.tags);
            this.setEventStatusCodes(model.eventStatusCodes);
        }

        public final Collection<String> getEventArns() {
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        public final Collection<String> getEventTypeCodes() {
            return this.eventTypeCodes;
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String ... eventTypeCodes) {
            this.eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
        }

        public final Collection<String> getServices() {
            return this.services;
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        public final Collection<String> getRegions() {
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<DateTimeRange> getStartTimes() {
            return this.startTimes;
        }

        @Override
        public final Builder startTimes(Collection<DateTimeRange> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copy(startTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startTimes(DateTimeRange ... startTimes) {
            this.startTimes(Arrays.asList(startTimes));
            return this;
        }

        public final void setStartTimes(Collection<DateTimeRange> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copy(startTimes);
        }

        public final Collection<DateTimeRange> getEndTimes() {
            return this.endTimes;
        }

        @Override
        public final Builder endTimes(Collection<DateTimeRange> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copy(endTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(DateTimeRange ... endTimes) {
            this.endTimes(Arrays.asList(endTimes));
            return this;
        }

        public final void setEndTimes(Collection<DateTimeRange> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copy(endTimes);
        }

        public final Collection<DateTimeRange> getLastUpdatedTimes() {
            return this.lastUpdatedTimes;
        }

        @Override
        public final Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(DateTimeRange ... lastUpdatedTimes) {
            this.lastUpdatedTimes(Arrays.asList(lastUpdatedTimes));
            return this;
        }

        public final void setLastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
        }

        public final Collection<String> getEntityArns() {
            return this.entityArns;
        }

        @Override
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityArns(String ... entityArns) {
            this.entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        public final Collection<String> getEntityValues() {
            return this.entityValues;
        }

        @Override
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityValues(String ... entityValues) {
            this.entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        public final Collection<String> getEventTypeCategories() {
            return this.eventTypeCategories;
        }

        @Override
        public final Builder eventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(String ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        public final Collection<Map<String, String>> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Map<String, String> ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
        }

        public final Collection<String> getEventStatusCodes() {
            return this.eventStatusCodes;
        }

        @Override
        public final Builder eventStatusCodes(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodes(String ... eventStatusCodes) {
            this.eventStatusCodes(Arrays.asList(eventStatusCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodes(EventStatusCode ... eventStatusCodes) {
            this.eventStatusCodes(Arrays.asList(eventStatusCodes).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setEventStatusCodes(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
        }

        public EventFilter build() {
            return new EventFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventFilter> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder eventTypeCodes(Collection<String> var1);

        public Builder eventTypeCodes(String ... var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder startTimes(Collection<DateTimeRange> var1);

        public Builder startTimes(DateTimeRange ... var1);

        public Builder endTimes(Collection<DateTimeRange> var1);

        public Builder endTimes(DateTimeRange ... var1);

        public Builder lastUpdatedTimes(Collection<DateTimeRange> var1);

        public Builder lastUpdatedTimes(DateTimeRange ... var1);

        public Builder entityArns(Collection<String> var1);

        public Builder entityArns(String ... var1);

        public Builder entityValues(Collection<String> var1);

        public Builder entityValues(String ... var1);

        public Builder eventTypeCategories(Collection<String> var1);

        public Builder eventTypeCategories(String ... var1);

        public Builder eventTypeCategories(EventTypeCategory ... var1);

        public Builder tags(Collection<Map<String, String>> var1);

        public Builder tags(Map<String, String> ... var1);

        public Builder eventStatusCodes(Collection<String> var1);

        public Builder eventStatusCodes(String ... var1);

        public Builder eventStatusCodes(EventStatusCode ... var1);
    }
}

