/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.Event;
import software.amazon.awssdk.services.health.model.EventDescription;
import software.amazon.awssdk.services.health.model._eventMetadataCopier;
import software.amazon.awssdk.services.health.transform.EventDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, EventDetails> {
    private final Event event;
    private final EventDescription eventDescription;
    private final Map<String, String> eventMetadata;

    private EventDetails(BuilderImpl builder) {
        this.event = builder.event;
        this.eventDescription = builder.eventDescription;
        this.eventMetadata = builder.eventMetadata;
    }

    public Event event() {
        return this.event;
    }

    public EventDescription eventDescription() {
        return this.eventDescription;
    }

    public Map<String, String> eventMetadata() {
        return this.eventMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.event() == null ? 0 : this.event().hashCode());
        hashCode = 31 * hashCode + (this.eventDescription() == null ? 0 : this.eventDescription().hashCode());
        hashCode = 31 * hashCode + (this.eventMetadata() == null ? 0 : this.eventMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDetails)) {
            return false;
        }
        EventDetails other = (EventDetails)obj;
        if (other.event() == null ^ this.event() == null) {
            return false;
        }
        if (other.event() != null && !other.event().equals(this.event())) {
            return false;
        }
        if (other.eventDescription() == null ^ this.eventDescription() == null) {
            return false;
        }
        if (other.eventDescription() != null && !other.eventDescription().equals(this.eventDescription())) {
            return false;
        }
        if (other.eventMetadata() == null ^ this.eventMetadata() == null) {
            return false;
        }
        return other.eventMetadata() == null || other.eventMetadata().equals(this.eventMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.event() != null) {
            sb.append("Event: ").append(this.event()).append(",");
        }
        if (this.eventDescription() != null) {
            sb.append("EventDescription: ").append(this.eventDescription()).append(",");
        }
        if (this.eventMetadata() != null) {
            sb.append("EventMetadata: ").append(this.eventMetadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Event event;
        private EventDescription eventDescription;
        private Map<String, String> eventMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDetails model) {
            this.setEvent(model.event);
            this.setEventDescription(model.eventDescription);
            this.setEventMetadata(model.eventMetadata);
        }

        public final Event getEvent() {
            return this.event;
        }

        @Override
        public final Builder event(Event event) {
            this.event = event;
            return this;
        }

        public final void setEvent(Event event) {
            this.event = event;
        }

        public final EventDescription getEventDescription() {
            return this.eventDescription;
        }

        @Override
        public final Builder eventDescription(EventDescription eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        public final void setEventDescription(EventDescription eventDescription) {
            this.eventDescription = eventDescription;
        }

        public final Map<String, String> getEventMetadata() {
            return this.eventMetadata;
        }

        @Override
        public final Builder eventMetadata(Map<String, String> eventMetadata) {
            this.eventMetadata = _eventMetadataCopier.copy(eventMetadata);
            return this;
        }

        public final void setEventMetadata(Map<String, String> eventMetadata) {
            this.eventMetadata = _eventMetadataCopier.copy(eventMetadata);
        }

        public EventDetails build() {
            return new EventDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventDetails> {
        public Builder event(Event var1);

        public Builder eventDescription(EventDescription var1);

        public Builder eventMetadata(Map<String, String> var1);
    }
}

