/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.transform.EventAggregateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventAggregate
implements StructuredPojo,
ToCopyableBuilder<Builder, EventAggregate> {
    private final String aggregateValue;
    private final Integer count;

    private EventAggregate(BuilderImpl builder) {
        this.aggregateValue = builder.aggregateValue;
        this.count = builder.count;
    }

    public String aggregateValue() {
        return this.aggregateValue;
    }

    public Integer count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.aggregateValue() == null ? 0 : this.aggregateValue().hashCode());
        hashCode = 31 * hashCode + (this.count() == null ? 0 : this.count().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventAggregate)) {
            return false;
        }
        EventAggregate other = (EventAggregate)obj;
        if (other.aggregateValue() == null ^ this.aggregateValue() == null) {
            return false;
        }
        if (other.aggregateValue() != null && !other.aggregateValue().equals(this.aggregateValue())) {
            return false;
        }
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        return other.count() == null || other.count().equals(this.count());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aggregateValue() != null) {
            sb.append("AggregateValue: ").append(this.aggregateValue()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventAggregateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String aggregateValue;
        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(EventAggregate model) {
            this.setAggregateValue(model.aggregateValue);
            this.setCount(model.count);
        }

        public final String getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        public final Builder aggregateValue(String aggregateValue) {
            this.aggregateValue = aggregateValue;
            return this;
        }

        public final void setAggregateValue(String aggregateValue) {
            this.aggregateValue = aggregateValue;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public EventAggregate build() {
            return new EventAggregate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventAggregate> {
        public Builder aggregateValue(String var1);

        public Builder count(Integer var1);
    }
}

