/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.DateTimeRange;
import software.amazon.awssdk.services.health.model.EntityStatusCode;
import software.amazon.awssdk.services.health.model._dateTimeRangeListCopier;
import software.amazon.awssdk.services.health.model._entityArnListCopier;
import software.amazon.awssdk.services.health.model._entityStatusCodeListCopier;
import software.amazon.awssdk.services.health.model._entityValueListCopier;
import software.amazon.awssdk.services.health.model._eventArnListCopier;
import software.amazon.awssdk.services.health.model._tagFilterCopier;
import software.amazon.awssdk.services.health.transform.EntityFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EntityFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, EntityFilter> {
    private final List<String> eventArns;
    private final List<String> entityArns;
    private final List<String> entityValues;
    private final List<DateTimeRange> lastUpdatedTimes;
    private final List<Map<String, String>> tags;
    private final List<String> statusCodes;

    private EntityFilter(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.lastUpdatedTimes = builder.lastUpdatedTimes;
        this.tags = builder.tags;
        this.statusCodes = builder.statusCodes;
    }

    public List<String> eventArns() {
        return this.eventArns;
    }

    public List<String> entityArns() {
        return this.entityArns;
    }

    public List<String> entityValues() {
        return this.entityValues;
    }

    public List<DateTimeRange> lastUpdatedTimes() {
        return this.lastUpdatedTimes;
    }

    public List<Map<String, String>> tags() {
        return this.tags;
    }

    public List<String> statusCodes() {
        return this.statusCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventArns() == null ? 0 : this.eventArns().hashCode());
        hashCode = 31 * hashCode + (this.entityArns() == null ? 0 : this.entityArns().hashCode());
        hashCode = 31 * hashCode + (this.entityValues() == null ? 0 : this.entityValues().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedTimes() == null ? 0 : this.lastUpdatedTimes().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.statusCodes() == null ? 0 : this.statusCodes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityFilter)) {
            return false;
        }
        EntityFilter other = (EntityFilter)obj;
        if (other.eventArns() == null ^ this.eventArns() == null) {
            return false;
        }
        if (other.eventArns() != null && !other.eventArns().equals(this.eventArns())) {
            return false;
        }
        if (other.entityArns() == null ^ this.entityArns() == null) {
            return false;
        }
        if (other.entityArns() != null && !other.entityArns().equals(this.entityArns())) {
            return false;
        }
        if (other.entityValues() == null ^ this.entityValues() == null) {
            return false;
        }
        if (other.entityValues() != null && !other.entityValues().equals(this.entityValues())) {
            return false;
        }
        if (other.lastUpdatedTimes() == null ^ this.lastUpdatedTimes() == null) {
            return false;
        }
        if (other.lastUpdatedTimes() != null && !other.lastUpdatedTimes().equals(this.lastUpdatedTimes())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.statusCodes() == null ^ this.statusCodes() == null) {
            return false;
        }
        return other.statusCodes() == null || other.statusCodes().equals(this.statusCodes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventArns() != null) {
            sb.append("EventArns: ").append(this.eventArns()).append(",");
        }
        if (this.entityArns() != null) {
            sb.append("EntityArns: ").append(this.entityArns()).append(",");
        }
        if (this.entityValues() != null) {
            sb.append("EntityValues: ").append(this.entityValues()).append(",");
        }
        if (this.lastUpdatedTimes() != null) {
            sb.append("LastUpdatedTimes: ").append(this.lastUpdatedTimes()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.statusCodes() != null) {
            sb.append("StatusCodes: ").append(this.statusCodes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> eventArns;
        private List<String> entityArns;
        private List<String> entityValues;
        private List<DateTimeRange> lastUpdatedTimes;
        private List<Map<String, String>> tags;
        private List<String> statusCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityFilter model) {
            this.setEventArns(model.eventArns);
            this.setEntityArns(model.entityArns);
            this.setEntityValues(model.entityValues);
            this.setLastUpdatedTimes(model.lastUpdatedTimes);
            this.setTags(model.tags);
            this.setStatusCodes(model.statusCodes);
        }

        public final Collection<String> getEventArns() {
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        public final Collection<String> getEntityArns() {
            return this.entityArns;
        }

        @Override
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityArns(String ... entityArns) {
            this.entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        public final Collection<String> getEntityValues() {
            return this.entityValues;
        }

        @Override
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityValues(String ... entityValues) {
            this.entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        public final Collection<DateTimeRange> getLastUpdatedTimes() {
            return this.lastUpdatedTimes;
        }

        @Override
        public final Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(DateTimeRange ... lastUpdatedTimes) {
            this.lastUpdatedTimes(Arrays.asList(lastUpdatedTimes));
            return this;
        }

        public final void setLastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
        }

        public final Collection<Map<String, String>> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Map<String, String> ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
        }

        public final Collection<String> getStatusCodes() {
            return this.statusCodes;
        }

        @Override
        public final Builder statusCodes(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusCodes(String ... statusCodes) {
            this.statusCodes(Arrays.asList(statusCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusCodes(EntityStatusCode ... statusCodes) {
            this.statusCodes(Arrays.asList(statusCodes).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setStatusCodes(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
        }

        public EntityFilter build() {
            return new EntityFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EntityFilter> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder entityArns(Collection<String> var1);

        public Builder entityArns(String ... var1);

        public Builder entityValues(Collection<String> var1);

        public Builder entityValues(String ... var1);

        public Builder lastUpdatedTimes(Collection<DateTimeRange> var1);

        public Builder lastUpdatedTimes(DateTimeRange ... var1);

        public Builder tags(Collection<Map<String, String>> var1);

        public Builder tags(Map<String, String> ... var1);

        public Builder statusCodes(Collection<String> var1);

        public Builder statusCodes(String ... var1);

        public Builder statusCodes(EntityStatusCode ... var1);
    }
}

