/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.health.model.EventType;
import software.amazon.awssdk.services.health.model.EventTypeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventTypesResponse> {
    private final List<EventType> eventTypes;
    private final String nextToken;

    private DescribeEventTypesResponse(BuilderImpl builder) {
        this.eventTypes = builder.eventTypes;
        this.nextToken = builder.nextToken;
    }

    public List<EventType> eventTypes() {
        return this.eventTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventTypes() == null ? 0 : this.eventTypes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTypesResponse)) {
            return false;
        }
        DescribeEventTypesResponse other = (DescribeEventTypesResponse)((Object)obj);
        if (other.eventTypes() == null ^ this.eventTypes() == null) {
            return false;
        }
        if (other.eventTypes() != null && !other.eventTypes().equals(this.eventTypes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventTypes() != null) {
            sb.append("EventTypes: ").append(this.eventTypes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EventType> eventTypes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTypesResponse model) {
            this.setEventTypes(model.eventTypes);
            this.setNextToken(model.nextToken);
        }

        public final Collection<EventType> getEventTypes() {
            return this.eventTypes;
        }

        @Override
        public final Builder eventTypes(Collection<EventType> eventTypes) {
            this.eventTypes = EventTypeListCopier.copy(eventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(EventType ... eventTypes) {
            this.eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        public final void setEventTypes(Collection<EventType> eventTypes) {
            this.eventTypes = EventTypeListCopier.copy(eventTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEventTypesResponse build() {
            return new DescribeEventTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventTypesResponse> {
        public Builder eventTypes(Collection<EventType> var1);

        public Builder eventTypes(EventType ... var1);

        public Builder nextToken(String var1);
    }
}

