/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsFailedSetCopier;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsSuccessfulSetCopier;
import software.amazon.awssdk.services.health.model.EventDetails;
import software.amazon.awssdk.services.health.model.EventDetailsErrorItem;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventDetailsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventDetailsResponse> {
    private final List<EventDetails> successfulSet;
    private final List<EventDetailsErrorItem> failedSet;

    private DescribeEventDetailsResponse(BuilderImpl builder) {
        this.successfulSet = builder.successfulSet;
        this.failedSet = builder.failedSet;
    }

    public List<EventDetails> successfulSet() {
        return this.successfulSet;
    }

    public List<EventDetailsErrorItem> failedSet() {
        return this.failedSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.successfulSet() == null ? 0 : this.successfulSet().hashCode());
        hashCode = 31 * hashCode + (this.failedSet() == null ? 0 : this.failedSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsResponse)) {
            return false;
        }
        DescribeEventDetailsResponse other = (DescribeEventDetailsResponse)((Object)obj);
        if (other.successfulSet() == null ^ this.successfulSet() == null) {
            return false;
        }
        if (other.successfulSet() != null && !other.successfulSet().equals(this.successfulSet())) {
            return false;
        }
        if (other.failedSet() == null ^ this.failedSet() == null) {
            return false;
        }
        return other.failedSet() == null || other.failedSet().equals(this.failedSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.successfulSet() != null) {
            sb.append("SuccessfulSet: ").append(this.successfulSet()).append(",");
        }
        if (this.failedSet() != null) {
            sb.append("FailedSet: ").append(this.failedSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EventDetails> successfulSet;
        private List<EventDetailsErrorItem> failedSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsResponse model) {
            this.setSuccessfulSet(model.successfulSet);
            this.setFailedSet(model.failedSet);
        }

        public final Collection<EventDetails> getSuccessfulSet() {
            return this.successfulSet;
        }

        @Override
        public final Builder successfulSet(Collection<EventDetails> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copy(successfulSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSet(EventDetails ... successfulSet) {
            this.successfulSet(Arrays.asList(successfulSet));
            return this;
        }

        public final void setSuccessfulSet(Collection<EventDetails> successfulSet) {
            this.successfulSet = DescribeEventDetailsSuccessfulSetCopier.copy(successfulSet);
        }

        public final Collection<EventDetailsErrorItem> getFailedSet() {
            return this.failedSet;
        }

        @Override
        public final Builder failedSet(Collection<EventDetailsErrorItem> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copy(failedSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(EventDetailsErrorItem ... failedSet) {
            this.failedSet(Arrays.asList(failedSet));
            return this;
        }

        public final void setFailedSet(Collection<EventDetailsErrorItem> failedSet) {
            this.failedSet = DescribeEventDetailsFailedSetCopier.copy(failedSet);
        }

        public DescribeEventDetailsResponse build() {
            return new DescribeEventDetailsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventDetailsResponse> {
        public Builder successfulSet(Collection<EventDetails> var1);

        public Builder successfulSet(EventDetails ... var1);

        public Builder failedSet(Collection<EventDetailsErrorItem> var1);

        public Builder failedSet(EventDetailsErrorItem ... var1);
    }
}

