/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.EntityStatusCode;
import software.amazon.awssdk.services.health.model._tagSetCopier;
import software.amazon.awssdk.services.health.transform.AffectedEntityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AffectedEntity
implements StructuredPojo,
ToCopyableBuilder<Builder, AffectedEntity> {
    private final String entityArn;
    private final String eventArn;
    private final String entityValue;
    private final String awsAccountId;
    private final Instant lastUpdatedTime;
    private final String statusCode;
    private final Map<String, String> tags;

    private AffectedEntity(BuilderImpl builder) {
        this.entityArn = builder.entityArn;
        this.eventArn = builder.eventArn;
        this.entityValue = builder.entityValue;
        this.awsAccountId = builder.awsAccountId;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.statusCode = builder.statusCode;
        this.tags = builder.tags;
    }

    public String entityArn() {
        return this.entityArn;
    }

    public String eventArn() {
        return this.eventArn;
    }

    public String entityValue() {
        return this.entityValue;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.entityArn() == null ? 0 : this.entityArn().hashCode());
        hashCode = 31 * hashCode + (this.eventArn() == null ? 0 : this.eventArn().hashCode());
        hashCode = 31 * hashCode + (this.entityValue() == null ? 0 : this.entityValue().hashCode());
        hashCode = 31 * hashCode + (this.awsAccountId() == null ? 0 : this.awsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedTime() == null ? 0 : this.lastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.statusCode() == null ? 0 : this.statusCode().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AffectedEntity)) {
            return false;
        }
        AffectedEntity other = (AffectedEntity)obj;
        if (other.entityArn() == null ^ this.entityArn() == null) {
            return false;
        }
        if (other.entityArn() != null && !other.entityArn().equals(this.entityArn())) {
            return false;
        }
        if (other.eventArn() == null ^ this.eventArn() == null) {
            return false;
        }
        if (other.eventArn() != null && !other.eventArn().equals(this.eventArn())) {
            return false;
        }
        if (other.entityValue() == null ^ this.entityValue() == null) {
            return false;
        }
        if (other.entityValue() != null && !other.entityValue().equals(this.entityValue())) {
            return false;
        }
        if (other.awsAccountId() == null ^ this.awsAccountId() == null) {
            return false;
        }
        if (other.awsAccountId() != null && !other.awsAccountId().equals(this.awsAccountId())) {
            return false;
        }
        if (other.lastUpdatedTime() == null ^ this.lastUpdatedTime() == null) {
            return false;
        }
        if (other.lastUpdatedTime() != null && !other.lastUpdatedTime().equals(this.lastUpdatedTime())) {
            return false;
        }
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.entityArn() != null) {
            sb.append("EntityArn: ").append(this.entityArn()).append(",");
        }
        if (this.eventArn() != null) {
            sb.append("EventArn: ").append(this.eventArn()).append(",");
        }
        if (this.entityValue() != null) {
            sb.append("EntityValue: ").append(this.entityValue()).append(",");
        }
        if (this.awsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.awsAccountId()).append(",");
        }
        if (this.lastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.lastUpdatedTime()).append(",");
        }
        if (this.statusCode() != null) {
            sb.append("StatusCode: ").append(this.statusCode()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AffectedEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String entityArn;
        private String eventArn;
        private String entityValue;
        private String awsAccountId;
        private Instant lastUpdatedTime;
        private String statusCode;
        private Map<String, String> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(AffectedEntity model) {
            this.setEntityArn(model.entityArn);
            this.setEventArn(model.eventArn);
            this.setEntityValue(model.entityValue);
            this.setAwsAccountId(model.awsAccountId);
            this.setLastUpdatedTime(model.lastUpdatedTime);
            this.setStatusCode(model.statusCode);
            this.setTags(model.tags);
        }

        public final String getEntityArn() {
            return this.entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        public final String getEntityValue() {
            return this.entityValue;
        }

        @Override
        public final Builder entityValue(String entityValue) {
            this.entityValue = entityValue;
            return this;
        }

        public final void setEntityValue(String entityValue) {
            this.entityValue = entityValue;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(EntityStatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = _tagSetCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = _tagSetCopier.copy(tags);
        }

        public AffectedEntity build() {
            return new AffectedEntity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AffectedEntity> {
        public Builder entityArn(String var1);

        public Builder eventArn(String var1);

        public Builder entityValue(String var1);

        public Builder awsAccountId(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder statusCode(String var1);

        public Builder statusCode(EntityStatusCode var1);

        public Builder tags(Map<String, String> var1);
    }
}

