/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.health.model.Event;

public class EventUnmarshaller
implements Unmarshaller<Event, JsonUnmarshallerContext> {
    private static final EventUnmarshaller INSTANCE = new EventUnmarshaller();

    public Event unmarshall(JsonUnmarshallerContext context) throws Exception {
        Event.Builder eventBuilder = Event.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    eventBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("service", targetDepth)) {
                    context.nextToken();
                    eventBuilder.service((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eventTypeCode", targetDepth)) {
                    context.nextToken();
                    eventBuilder.eventTypeCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eventTypeCategory", targetDepth)) {
                    context.nextToken();
                    eventBuilder.eventTypeCategory((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("region", targetDepth)) {
                    context.nextToken();
                    eventBuilder.region((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    context.nextToken();
                    eventBuilder.availabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("startTime", targetDepth)) {
                    context.nextToken();
                    eventBuilder.startTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("endTime", targetDepth)) {
                    context.nextToken();
                    eventBuilder.endTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("lastUpdatedTime", targetDepth)) {
                    context.nextToken();
                    eventBuilder.lastUpdatedTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("statusCode", targetDepth)) {
                    context.nextToken();
                    eventBuilder.statusCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Event)eventBuilder.build();
    }

    public static EventUnmarshaller getInstance() {
        return INSTANCE;
    }
}

